/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openl.rules.dt.DecisionTableColumnHeaders;
import org.openl.rules.dt.DecisionTableHelper;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.validation.properties.dimentional.AConditionBuilder;
import org.openl.rules.validation.properties.dimentional.ArrayConditionBuilder;
import org.openl.rules.validation.properties.dimentional.DispatcherTableReturnColumn;
import org.openl.rules.validation.properties.dimentional.IDecisionTableColumn;
import org.openl.rules.validation.properties.dimentional.IDecisionTableColumnBuilder;
import org.openl.rules.validation.properties.dimentional.SimpleConditionBuilder;
import org.openl.rules.validation.properties.dimentional.TableSyntaxNodeDispatcherBuilder;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;

public class DecisionTableBuilder {
    static final int DECISION_TABLE_HEADER_ROWS_NUMBER = 5;
    static final int CONDITION_TITLE_ROW_INDEX = 4;
    static final int PARAMETER_DECLARATION_ROW_INDEX = 3;
    static final int CODE_EXPRESSION_ROW_INDEX = 2;
    static final int COLUMN_TYPE_ROW_INDEX = 1;
    private String methodName;
    private List<IDecisionTableColumn> conditions;
    private DispatcherTableReturnColumn returnColumn;
    private String tableName;
    private int rulesNumber;

    private static String buildMethodHeader(String tableName, DispatcherTableReturnColumn returnColumn) {
        String type;
        IMethodSignature originalSignature = returnColumn.getOriginalSignature();
        StringBuilder builder = new StringBuilder(64);
        builder.append("Rules").append(' ').append(returnColumn.getReturnType().getDisplayName(0)).append(' ').append(tableName).append('(');
        boolean prependComma = false;
        for (int j = 0; j < originalSignature.getNumberOfParameters(); ++j) {
            IOpenClass parameterType = originalSignature.getParameterType(j);
            if (parameterType instanceof NullOpenClass || parameterType.getInstanceClass() == null) continue;
            if (prependComma) {
                builder.append(',');
            }
            type = parameterType.getInstanceClass().getSimpleName();
            builder.append(type).append(" arg_").append(originalSignature.getParameterName(j));
            prependComma = true;
        }
        for (Map.Entry<String, IOpenClass> param : TableSyntaxNodeDispatcherBuilder.INCOME_PARAMS.entrySet()) {
            if (prependComma) {
                builder.append(',');
            }
            type = param.getValue().getInstanceClass().getSimpleName();
            String name = param.getKey();
            builder.append(type).append(' ').append(name);
            prependComma = true;
        }
        builder.append(')');
        return builder.toString();
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    void setConditions(List<IDecisionTableColumn> conditions) {
        this.conditions = conditions;
    }

    void setReturnColumn(DispatcherTableReturnColumn returnColumn) {
        this.returnColumn = returnColumn;
    }

    void setTableName(String tableName) {
        this.tableName = tableName;
    }

    void setRulesNumber(int rulesNumber) {
        this.rulesNumber = rulesNumber;
    }

    /*
     * WARNING - void declaration
     */
    public XlsSheetGridModel build() {
        void var5_9;
        XlsSheetGridModel sheetWithTable = DecisionTableHelper.createVirtualGrid();
        int conditionsNumber = 0;
        ArrayList<AConditionBuilder> conditionBuilders = new ArrayList<AConditionBuilder>();
        for (IDecisionTableColumn iDecisionTableColumn : this.conditions) {
            if (iDecisionTableColumn.getNumberOfLocalParameters() <= 0) continue;
            ++conditionsNumber;
            if (iDecisionTableColumn.getNumberOfLocalParameters() > 1) {
                conditionBuilders.add(new ArrayConditionBuilder(iDecisionTableColumn, conditionsNumber));
                continue;
            }
            conditionBuilders.add(new SimpleConditionBuilder(iDecisionTableColumn, conditionsNumber));
        }
        int column = 0;
        for (IDecisionTableColumnBuilder iDecisionTableColumnBuilder : conditionBuilders) {
            int columnUsedForCondition = iDecisionTableColumnBuilder.build(sheetWithTable, this.rulesNumber, column, 0);
            column += columnUsedForCondition;
        }
        sheetWithTable.setCellValue(column, 1, DecisionTableColumnHeaders.RETURN.getHeaderKey());
        sheetWithTable.setCellValue(column, 2, this.returnColumn.getCodeExpression());
        sheetWithTable.setCellValue(column, 3, this.returnColumn.getParameterDeclaration());
        sheetWithTable.setCellValue(column, 4, this.returnColumn.getTitle());
        boolean bl = false;
        while (var5_9 < this.rulesNumber) {
            sheetWithTable.setCellValue(column, (int)(var5_9 + 5), this.returnColumn.getRuleValue((int)var5_9));
            ++var5_9;
        }
        String string = DecisionTableBuilder.buildMethodHeader(this.tableName, this.returnColumn);
        sheetWithTable.setCellValue(0, 0, string);
        sheetWithTable.addMergedRegion(new GridRegion(0, 0, 0, column));
        return sheetWithTable;
    }
}

