/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import org.openl.binding.IBoundNode;
import org.openl.binding.impl.BlockNode;
import org.openl.binding.impl.CastNode;
import org.openl.binding.impl.IfNode;
import org.openl.binding.impl.LiteralBoundNode;
import org.openl.binding.impl.LoopNode;
import org.openl.binding.impl.ReturnNode;

final class BoundNodeAnalyzingUtils {
    private BoundNodeAnalyzingUtils() {
    }

    public static boolean nodeMayCompleteNormally(IBoundNode node) {
        if (node == null) {
            return true;
        }
        if (node instanceof ReturnNode) {
            return false;
        }
        if (node instanceof LoopNode) {
            return BoundNodeAnalyzingUtils.loopNodeMayCompleteNormally((LoopNode)node);
        }
        if (node instanceof IfNode) {
            return BoundNodeAnalyzingUtils.ifNodeMayCompleteNormally((IfNode)node);
        }
        if (node instanceof CastNode) {
            return BoundNodeAnalyzingUtils.nodeMayCompleteNormally(node.getChildren()[0]);
        }
        if (node instanceof BlockNode) {
            return BoundNodeAnalyzingUtils.blockNodeMayCompleteNormally((BlockNode)node);
        }
        return true;
    }

    private static boolean loopNodeMayCompleteNormally(LoopNode loopNode) {
        IBoundNode conditionNode = loopNode.getConditionNode();
        if (conditionNode == null) {
            return false;
        }
        Object value = BoundNodeAnalyzingUtils.computeConstantExpression(conditionNode);
        return Boolean.TRUE != value;
    }

    private static boolean ifNodeMayCompleteNormally(IfNode ifNode) {
        IBoundNode conditionNode = ifNode.getConditionNode();
        if (conditionNode instanceof LiteralBoundNode) {
            Object value = BoundNodeAnalyzingUtils.computeConstantExpression(conditionNode);
            if (Boolean.TRUE == value) {
                return BoundNodeAnalyzingUtils.nodeMayCompleteNormally(ifNode.getThenNode());
            }
            if (Boolean.FALSE == value) {
                return BoundNodeAnalyzingUtils.nodeMayCompleteNormally(ifNode.getElseNode());
            }
        }
        return BoundNodeAnalyzingUtils.nodeMayCompleteNormally(ifNode.getThenNode()) || BoundNodeAnalyzingUtils.nodeMayCompleteNormally(ifNode.getElseNode());
    }

    private static boolean blockNodeMayCompleteNormally(BlockNode blockNode) {
        IBoundNode[] children;
        if (blockNode == null) {
            return true;
        }
        for (IBoundNode child : children = blockNode.getChildren()) {
            if (BoundNodeAnalyzingUtils.nodeMayCompleteNormally(child)) continue;
            return false;
        }
        return true;
    }

    private static Object computeConstantExpression(IBoundNode conditionNode) {
        if (!(conditionNode instanceof LiteralBoundNode)) {
            return null;
        }
        LiteralBoundNode literalNode = (LiteralBoundNode)conditionNode;
        return literalNode.getValue();
    }
}

