/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types.impl;

import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.types.impl.IntersectionType;

public abstract class IntersectionConstraint<P> {
    protected abstract IntersectionType matchNotNulls(P var1, P var2);

    protected abstract P getPropertyValue(ITableProperties var1);

    public IntersectionType match(ITableProperties firstProperties, ITableProperties secondProperties) {
        P firstValue = this.getPropertyValue(firstProperties);
        P secondValue = this.getPropertyValue(secondProperties);
        return this.matchValues(firstValue, secondValue);
    }

    protected IntersectionType matchValues(P firstValue, P secondValue) {
        if (firstValue == secondValue) {
            return IntersectionType.EQUALS;
        }
        if (firstValue == null) {
            return IntersectionType.CONTAINS;
        }
        if (secondValue == null) {
            return IntersectionType.NESTED;
        }
        return this.matchNotNulls(firstValue, secondValue);
    }

    protected static <T> IntersectionType intersectionForLE(Comparable<T> firstValue, Comparable<T> secondValue) {
        int comparison = firstValue.compareTo(secondValue);
        return comparison == 0 ? IntersectionType.EQUALS : (comparison < 0 ? IntersectionType.CONTAINS : IntersectionType.NESTED);
    }

    protected static <T> IntersectionType intersectionForGE(Comparable<T> firstValue, Comparable<T> secondValue) {
        int comparison = firstValue.compareTo(secondValue);
        return comparison == 0 ? IntersectionType.EQUALS : (comparison > 0 ? IntersectionType.CONTAINS : IntersectionType.NESTED);
    }

    protected static <T> IntersectionType intersectionForEQ(Comparable<T> firstValue, Comparable<T> secondValue) {
        return firstValue.compareTo(secondValue) == 0 ? IntersectionType.EQUALS : IntersectionType.NO_INTERSECTION;
    }

    protected static <T> IntersectionType intersectionForCONTAINS(Comparable<T>[] firstValue, Comparable<T>[] secondValue) {
        IntersectionType resultForNoAbsentElements;
        if (firstValue.length > secondValue.length) {
            resultForNoAbsentElements = IntersectionType.CONTAINS;
            Comparable<T>[] swap = firstValue;
            firstValue = secondValue;
            secondValue = swap;
        } else {
            resultForNoAbsentElements = firstValue.length < secondValue.length ? IntersectionType.NESTED : IntersectionType.EQUALS;
        }
        boolean hasEqualElements = false;
        boolean hasAbsentElements = false;
        for (Comparable<T> value : firstValue) {
            if (IntersectionConstraint.containsElement(secondValue, value)) {
                hasEqualElements = true;
                continue;
            }
            hasAbsentElements = true;
        }
        if (!hasAbsentElements) {
            return resultForNoAbsentElements;
        }
        return hasEqualElements ? IntersectionType.PARTLY_INTERSECTS : IntersectionType.NO_INTERSECTION;
    }

    private static <T> boolean containsElement(Comparable<T>[] cmp1, Comparable<T> cmp2) {
        for (Comparable<Comparable<Comparable<T>>> comparable : cmp1) {
            if (comparable.compareTo(cmp2) != 0) continue;
            return true;
        }
        return false;
    }
}

