/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.table.properties.expressions.sequence.IntersectedPropertiesPriorityRule;
import org.openl.rules.types.impl.ITablePropertiesSorter;
import org.openl.types.IOpenMethod;

public class DefaultTablePropertiesSorter
implements ITablePropertiesSorter {
    private final List<Comparator<ITableProperties>> maxMinPriorityRules = new ArrayList<Comparator<ITableProperties>>();
    private final List<Comparator<ITableProperties>> tablesPriorityRules = new ArrayList<Comparator<ITableProperties>>();
    private Comparator<IOpenMethod> methodsComparator;

    public DefaultTablePropertiesSorter() {
        this.initTablesPriorityRules();
        this.initMethodsComparator();
    }

    private void initTablesPriorityRules() {
        this.maxMinPriorityRules.add(Comparator.comparing(ITableProperties::getStartRequestDate, Comparator.nullsLast(Comparator.reverseOrder())));
        this.maxMinPriorityRules.add(Comparator.comparing(ITableProperties::getEndRequestDate, Comparator.nullsLast(Comparator.naturalOrder())));
        this.maxMinPriorityRules.add(Comparator.comparing(ITableProperties::getEffectiveDate, Comparator.nullsLast(Comparator.reverseOrder())));
        this.maxMinPriorityRules.add(Comparator.comparing(ITableProperties::getOrigin, Comparator.nullsLast(Comparator.reverseOrder())));
        this.tablesPriorityRules.addAll(this.maxMinPriorityRules);
        this.tablesPriorityRules.add(new IntersectedPropertiesPriorityRule());
    }

    private void initMethodsComparator() {
        this.methodsComparator = (o1, o2) -> {
            Comparator<ITableProperties> tablesPriorityRule;
            ITableProperties tableProperties1 = PropertiesHelper.getTableProperties(o1);
            ITableProperties tableProperties2 = PropertiesHelper.getTableProperties(o2);
            int comparisonResult = 0;
            Iterator<Comparator<ITableProperties>> iterator = this.tablesPriorityRules.iterator();
            while (iterator.hasNext() && (comparisonResult = (tablesPriorityRule = iterator.next()).compare(tableProperties1, tableProperties2)) == 0) {
            }
            return comparisonResult;
        };
    }

    @Override
    public List<IOpenMethod> sort(Collection<IOpenMethod> candidates) {
        ArrayList<IOpenMethod> result = new ArrayList<IOpenMethod>(candidates);
        result.sort(this.methodsComparator);
        return result;
    }

    @Override
    public Comparator<IOpenMethod> getMethodsComparator() {
        return this.methodsComparator;
    }

    public List<Comparator<ITableProperties>> getMaxMinPriorityRules() {
        return this.maxMinPriorityRules;
    }
}

