/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.export;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.openl.rules.table.xls.PoiExcelHelper;

final class Styles {
    static final int HEADER = 0xBFBFBF;
    static final int GREEN_MAIN = 12900251;
    static final int RED_MAIN = 14325396;
    static final int GREEN_FIELDS = 14214332;
    static final int RED_FIELDS = 15120567;
    static final int ABSENT_VALUE = 0xEFEFEF;
    final CellStyle testNameSuccess;
    final CellStyle testNameFailure;
    final CellStyle testInfo;
    final CellStyle header;
    final CellStyle resultSuccessId;
    final CellStyle resultFailureId;
    final CellStyle resultSuccessStatus;
    final CellStyle resultFailureStatus;
    final CellStyle resultSuccess;
    final CellStyle resultFailure;
    final CellStyle resultOther;
    final CellStyle parametersInfo;
    final CellStyle parameterValue;
    final CellStyle parameterAbsent;
    private final Map<CellStyle, CellStyle> dateStyles = new HashMap<CellStyle, CellStyle>();

    Styles(SXSSFWorkbook wb) {
        this.testNameSuccess = this.textStyle((Workbook)wb, this.createFont((Workbook)wb, HSSFColor.HSSFColorPredefined.GREEN.getIndex()));
        this.testNameFailure = this.textStyle((Workbook)wb, this.createFont((Workbook)wb, HSSFColor.HSSFColorPredefined.RED.getIndex()));
        this.testInfo = this.textStyle((Workbook)wb, this.createFont((Workbook)wb, HSSFColor.HSSFColorPredefined.GREY_50_PERCENT.getIndex()));
        this.header = this.backgroundStyle(wb, 0xBFBFBF);
        this.resultSuccessId = this.backgroundStyle(wb, 12900251);
        this.resultFailureId = this.backgroundStyle(wb, 14325396);
        this.resultSuccessStatus = this.backgroundStyle(wb, 12900251, this.createFont((Workbook)wb, HSSFColor.HSSFColorPredefined.GREEN.getIndex()));
        this.resultFailureStatus = this.backgroundStyle(wb, 14325396, this.createFont((Workbook)wb, HSSFColor.HSSFColorPredefined.RED.getIndex()));
        this.resultSuccess = this.backgroundStyle(wb, 14214332);
        this.resultFailure = this.backgroundStyle(wb, 15120567);
        this.resultOther = this.backgroundStyle(wb, null);
        this.parametersInfo = this.textStyle((Workbook)wb, this.createFont((Workbook)wb, HSSFColor.HSSFColorPredefined.BLACK.getIndex()));
        this.parameterValue = this.backgroundStyle(wb, null);
        this.parameterAbsent = this.backgroundStyle(wb, 0xEFEFEF);
    }

    CellStyle getDateStyle(Workbook workbook, CellStyle original) {
        Object dateStyle = this.dateStyles.get(original);
        if (dateStyle == null) {
            dateStyle = PoiExcelHelper.createCellStyle(workbook);
            dateStyle.cloneStyleFrom(original);
            dateStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"m/d/yy"));
            this.dateStyles.put(original, (CellStyle)dateStyle);
        }
        return dateStyle;
    }

    private CellStyle textStyle(Workbook workbook, Font font) {
        CellStyle style = workbook.createCellStyle();
        if (font != null) {
            style.setFont(font);
        }
        return style;
    }

    private CellStyle backgroundStyle(SXSSFWorkbook workbook, Integer rgb) {
        return this.backgroundStyle(workbook, rgb, null);
    }

    private CellStyle backgroundStyle(SXSSFWorkbook workbook, Integer rgb, Font font) {
        XSSFCellStyle style = (XSSFCellStyle)workbook.createCellStyle();
        if (rgb != null) {
            IndexedColorMap indexedColors = workbook.getXSSFWorkbook().getStylesSource().getIndexedColors();
            XSSFColor color = new XSSFColor(Styles.convertRGB(rgb), indexedColors);
            style.setFillForegroundColor(color);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        if (font != null) {
            style.setFont(font);
        }
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    private Font createFont(Workbook workbook, short color) {
        Font font = workbook.createFont();
        font.setColor(color);
        font.setBold(true);
        return font;
    }

    static byte[] convertRGB(int rgb) {
        byte red = (byte)(rgb >> 16 & 0xFF);
        byte green = (byte)(rgb >> 8 & 0xFF);
        byte blue = (byte)(rgb & 0xFF);
        return new byte[]{red, green, blue};
    }
}

