/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.builder;

import java.util.List;
import java.util.Map;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.table.xls.builder.TableBuilder;

public class SimpleRulesTableBuilder
extends TableBuilder {
    public static final int LOGIC_ELEMENT_HEIGHT = 1;
    private int elementColumn;

    public SimpleRulesTableBuilder(XlsSheetGridModel gridModel) {
        super(gridModel);
    }

    @Override
    public void beginTable(int width, int height) throws CreateTableException {
        super.beginTable(width, height);
        this.elementColumn = 0;
    }

    @Override
    public void endTable() throws CreateTableException {
        if (this.elementColumn > 0) {
            this.incCurrentRow(1);
        }
        super.endTable();
    }

    public void writeTableBodyRow(List<Map<String, Object>> row) {
        int i = 0;
        for (Map<String, Object> cell : row) {
            this.writeCell(i, this.getCurrentRow(), 1, 1, cell.get("value"), (ICellStyle)cell.get("style"));
            ++i;
        }
        this.incCurrentRow(1);
    }

    @Override
    public void writeHeader(String signature, ICellStyle style) {
        String headerText = "SimpleRules " + signature;
        super.writeHeader(headerText, style);
    }
}

