/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openl.rules.table.xls.builder.DataTableField;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;

public class DataTableUserDefinedTypeField
extends DataTableField {
    private final IOpenClass type;
    private List<DataTableField> availableFields;
    private final PredefinedTypeChecker predefinedChecker;

    public DataTableUserDefinedTypeField(IOpenClass type, String name, PredefinedTypeChecker predefinedChecker) {
        this(type, name, name.toUpperCase(), predefinedChecker);
    }

    public DataTableUserDefinedTypeField(IOpenClass type, String name, String businessName, PredefinedTypeChecker predefinedChecker) {
        super(name, businessName);
        this.type = type;
        this.predefinedChecker = predefinedChecker;
    }

    public IOpenClass getType() {
        return this.type;
    }

    @Override
    protected List<DataTableField> getAvailableFields() {
        if (this.availableFields == null) {
            ArrayList<DataTableUserDefinedTypeField> list = new ArrayList<DataTableUserDefinedTypeField>();
            for (IOpenField field : this.getType().getFields()) {
                if (field.isConst() || !field.isWritable()) continue;
                list.add(new DataTableUserDefinedTypeField(field.getType(), field.getName(), this.predefinedChecker));
            }
            this.availableFields = Collections.unmodifiableList(list);
        }
        return this.availableFields;
    }

    @Override
    public String getTypeName() {
        return this.getType().getDisplayName(0);
    }

    @Override
    public boolean isComplex() {
        return !this.getType().isSimple() && !this.getType().isArray() && !this.predefinedChecker.isPredefined(this.getType());
    }

    public static interface PredefinedTypeChecker {
        public boolean isPredefined(IOpenClass var1);
    }
}

