/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.ui;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.openl.rules.table.ui.ICellStyle;

public class CellStyle
implements ICellStyle {
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.GENERAL;
    private VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    private short[] fillBackgroundColor;
    private short[] fillForegroundColor;
    private short fillBackgroundColorIndex;
    private short fillForegroundColorIndex;
    private FillPatternType fillPattern;
    private BorderStyle[] borderStyle;
    private short[][] borderRGB;
    private int indent;
    private boolean wrappedText;
    private int rotation;
    private short formatIndex;
    private String formatString;

    public CellStyle(ICellStyle cellStyle) {
        if (cellStyle == null) {
            return;
        }
        this.horizontalAlignment = cellStyle.getHorizontalAlignment();
        this.verticalAlignment = cellStyle.getVerticalAlignment();
        this.fillBackgroundColor = cellStyle.getFillBackgroundColor();
        this.fillForegroundColor = cellStyle.getFillForegroundColor();
        this.fillBackgroundColorIndex = cellStyle.getFillBackgroundColorIndex();
        this.fillForegroundColorIndex = cellStyle.getFillForegroundColorIndex();
        this.fillPattern = cellStyle.getFillPattern();
        this.borderStyle = cellStyle.getBorderStyle();
        this.borderRGB = cellStyle.getBorderRGB();
        this.indent = cellStyle.getIndent();
        this.wrappedText = cellStyle.isWrappedText();
        this.rotation = cellStyle.getRotation();
        this.formatIndex = cellStyle.getFormatIndex();
        this.formatString = cellStyle.getFormatString();
    }

    @Override
    public short[][] getBorderRGB() {
        return this.borderRGB;
    }

    @Override
    public BorderStyle[] getBorderStyle() {
        return this.borderStyle;
    }

    @Override
    public short[] getFillBackgroundColor() {
        return this.fillBackgroundColor;
    }

    @Override
    public short[] getFillForegroundColor() {
        return this.fillForegroundColor;
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public int getIndent() {
        return this.indent;
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public boolean isWrappedText() {
        return this.wrappedText;
    }

    public void setBorderRGB(short[][] borderRGB) {
        this.borderRGB = borderRGB;
    }

    public void setBorderStyle(BorderStyle[] borderStyle) {
        this.borderStyle = borderStyle;
    }

    public void setFillBackgroundColor(short[] fillBackgroundColor) {
        this.fillBackgroundColor = fillBackgroundColor;
    }

    public void setFillForegroundColor(short[] fillForegroundColor) {
        this.fillForegroundColor = fillForegroundColor;
    }

    @Override
    public short getFillBackgroundColorIndex() {
        return this.fillBackgroundColorIndex;
    }

    @Override
    public short getFillForegroundColorIndex() {
        return this.fillForegroundColorIndex;
    }

    @Override
    public FillPatternType getFillPattern() {
        return this.fillPattern;
    }

    @Override
    public short getFormatIndex() {
        return this.formatIndex;
    }

    @Override
    public String getFormatString() {
        return this.formatString;
    }
}

