/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.formatters;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public interface Formats {
    public String date();

    public String dateTime();

    default public String formatDate(Date date) {
        return new SimpleDateFormat(this.date()).format(date);
    }

    default public String formatDateTime(Date date) {
        return new SimpleDateFormat(this.dateTime()).format(date);
    }

    default public String formatDateOrDateTime(Date date) {
        LocalDateTime dateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        if (dateTime.getHour() == 0 && dateTime.getMinute() == 0) {
            return this.formatDate(date);
        }
        return this.formatDateTime(date);
    }
}

