/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.table.AGridTableDecorator;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;

public class GridTableUtils {
    private GridTableUtils() {
    }

    public static IGridTable getOriginalTable(IGridTable table) {
        IGridTable resultTable = table;
        while (resultTable instanceof AGridTableDecorator) {
            resultTable = ((AGridTableDecorator)resultTable).getOriginalGridTable();
        }
        return resultTable;
    }

    public static List<IGridRegion> getGridRegions(ILogicalTable table) {
        int height = table.getHeight();
        int width = table.getWidth();
        ArrayList<IGridRegion> regions = new ArrayList<IGridRegion>();
        for (int row = 0; row < height; ++row) {
            for (int column = 0; column < width; ++column) {
                ICell cell = table.getCell(column, row);
                regions.add(cell.getAbsoluteRegion());
            }
        }
        return regions;
    }

    public static boolean isSingleCellTable(ILogicalTable table) {
        return table.getHeight() == 1 && table.getWidth() == 1;
    }
}

