/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types.meta;

import java.util.Collections;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.IMetaInfo;
import org.openl.rules.datatype.binding.DatatypeTableBoundNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.lang.xls.types.meta.BaseMetaInfoReader;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeTableMetaInfoReader
extends BaseMetaInfoReader<DatatypeTableBoundNode> {
    private static final Logger LOG = LoggerFactory.getLogger(DatatypeTableMetaInfoReader.class);

    public DatatypeTableMetaInfoReader(DatatypeTableBoundNode boundNode) {
        super(boundNode);
    }

    @Override
    protected TableSyntaxNode getTableSyntaxNode() {
        return ((DatatypeTableBoundNode)this.getBoundNode()).getTableSyntaxNode();
    }

    @Override
    protected CellMetaInfo getHeaderMetaInfo() {
        DatatypeOpenClass dataType = ((DatatypeTableBoundNode)this.getBoundNode()).getDataType();
        IdentifierNode identifier = ((DatatypeTableBoundNode)this.getBoundNode()).getParentClassIdentifier();
        if (identifier != null && dataType.getSuperClass() != null) {
            return DatatypeTableMetaInfoReader.createMetaInfo(identifier, dataType.getSuperClass().getMetaInfo());
        }
        return null;
    }

    @Override
    public CellMetaInfo getBodyMetaInfo(int row, int col) {
        ILogicalTable logicalTable = ((DatatypeTableBoundNode)this.getBoundNode()).getTable();
        ICell firstCell = logicalTable.getCell(0, 0);
        int r = row - firstCell.getAbsoluteRow();
        int c = col - firstCell.getAbsoluteColumn();
        if (r < 0 || c < 0) {
            return this.getHeaderMetaInfo();
        }
        if (!logicalTable.isNormalOrientation()) {
            int temp = r;
            r = c;
            c = temp;
        }
        if (c > 0) {
            if (c == 2) {
                try {
                    ILogicalTable logicalRow = (ILogicalTable)logicalTable.getRow(r);
                    IOpenField field = this.getField(logicalRow);
                    if (field == null) {
                        return null;
                    }
                    IOpenClass type = field.getType();
                    boolean multiValue = false;
                    if (type.getAggregateInfo().isAggregate(type)) {
                        type = type.getAggregateInfo().getComponentType(type);
                        multiValue = true;
                    }
                    return new CellMetaInfo(type, multiValue);
                }
                catch (OpenLCompilationException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        ILogicalTable logicalRow = (ILogicalTable)logicalTable.getRow(r);
        GridCellSourceCodeModule typeCellSource = DatatypeTableBoundNode.getCellSource(logicalRow, null, 0);
        if (!ParserUtils.isBlankOrCommented((String)typeCellSource.getCode())) {
            try {
                IOpenField field = this.getField(logicalRow);
                if (field == null) {
                    return null;
                }
                IMetaInfo fieldMetaInfo = field.getType().getMetaInfo();
                IdentifierNode[] idn = Tokenizer.tokenize((IOpenSourceCodeModule)typeCellSource, (String)"[]\n\r");
                return DatatypeTableMetaInfoReader.createMetaInfo(idn[0], fieldMetaInfo);
            }
            catch (OpenLCompilationException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private IOpenField getField(ILogicalTable logicalRow) throws OpenLCompilationException {
        String fieldName = DatatypeTableMetaInfoReader.getName(logicalRow);
        if (fieldName == null) {
            return null;
        }
        DatatypeOpenClass dataType = ((DatatypeTableBoundNode)this.getBoundNode()).getDataType();
        IOpenField field = dataType.getField(fieldName);
        if (field == null) {
            return null;
        }
        return field;
    }

    private static CellMetaInfo createMetaInfo(IdentifierNode identifier, IMetaInfo typeMeta) {
        if (typeMeta == null) {
            return null;
        }
        SimpleNodeUsage nodeUsage = new SimpleNodeUsage(identifier, typeMeta.getDisplayName(0), typeMeta.getSourceUrl(), NodeType.DATATYPE);
        return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(nodeUsage));
    }

    private static String getName(ILogicalTable row) throws OpenLCompilationException {
        GridCellSourceCodeModule nameCellSource = DatatypeTableBoundNode.getCellSource(row, null, 1);
        IdentifierNode[] idn = Tokenizer.tokenize((IOpenSourceCodeModule)nameCellSource, (String)" \r\n");
        if (idn.length != 1) {
            return null;
        }
        String name = idn[0].getIdentifier();
        if (name.endsWith("~") || name.endsWith("*")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }
}

