/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types;

import java.util.List;
import org.openl.binding.impl.NodeUsage;
import org.openl.types.IOpenClass;
import org.openl.util.CollectionUtils;

public class CellMetaInfo {
    private static final int MULTI = 1;
    private static final int RETURN_CELL = 2;
    private final IOpenClass domain;
    private int flags;
    private List<? extends NodeUsage> usedNodes;

    public CellMetaInfo(IOpenClass domain, boolean multiValue) {
        this(domain, multiValue, null);
    }

    public CellMetaInfo(IOpenClass domain, boolean multiValue, List<? extends NodeUsage> usedNodes) {
        this(domain, multiValue, usedNodes, false);
    }

    public CellMetaInfo(IOpenClass domain, boolean multiValue, List<? extends NodeUsage> usedNodes, boolean returnHeader) {
        this.domain = domain;
        this.usedNodes = usedNodes;
        if (multiValue) {
            this.flags |= 1;
        }
        if (returnHeader) {
            this.flags |= 2;
        }
    }

    public boolean isReturnCell() {
        return (this.flags & 2) > 0;
    }

    public IOpenClass getDataType() {
        return this.domain;
    }

    public boolean isMultiValue() {
        return (this.flags & 1) > 0;
    }

    public List<? extends NodeUsage> getUsedNodes() {
        return this.usedNodes;
    }

    public void setUsedNodes(List<? extends NodeUsage> usedNodes) {
        this.usedNodes = usedNodes;
    }

    public static boolean isCellContainsNodeUsages(CellMetaInfo metaInfo) {
        return metaInfo != null && CollectionUtils.isNotEmpty(metaInfo.getUsedNodes());
    }
}

