/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.syntax;

import java.util.ArrayList;
import java.util.Arrays;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.WorksheetSyntaxNode;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.NaryNode;

public class WorkbookSyntaxNode
extends NaryNode {
    private final TableSyntaxNode[] mergedTableParts;
    private TableSyntaxNode[] tableSyntaxNodes = null;

    public WorkbookSyntaxNode(WorksheetSyntaxNode[] nodes, TableSyntaxNode[] mergedTableParts, XlsWorkbookSourceCodeModule module) {
        super(XlsNodeTypes.XLS_WORKBOOK.toString(), null, (ISyntaxNode[])nodes, (IOpenSourceCodeModule)module);
        this.mergedTableParts = mergedTableParts;
    }

    public TableSyntaxNode[] getTableSyntaxNodes() {
        if (this.tableSyntaxNodes == null) {
            this.buildTableSyntaxNodes();
        } else {
            int expectedSize = 0;
            for (WorksheetSyntaxNode sheetNode : this.getWorksheetSyntaxNodes()) {
                expectedSize += sheetNode.getTableSyntaxNodes().length;
            }
            if ((expectedSize += this.mergedTableParts.length) != this.tableSyntaxNodes.length) {
                this.buildTableSyntaxNodes();
            }
        }
        return this.tableSyntaxNodes;
    }

    private void buildTableSyntaxNodes() {
        WorksheetSyntaxNode[] sheetNodes;
        ArrayList<TableSyntaxNode> tnodes = new ArrayList<TableSyntaxNode>();
        for (WorksheetSyntaxNode sheetNode : sheetNodes = this.getWorksheetSyntaxNodes()) {
            TableSyntaxNode[] tableSyntaxNodes = sheetNode.getTableSyntaxNodes();
            tnodes.addAll(Arrays.asList(tableSyntaxNodes));
        }
        tnodes.addAll(Arrays.asList(this.mergedTableParts));
        this.tableSyntaxNodes = tnodes.toArray(TableSyntaxNode.EMPTY_ARRAY);
    }

    public XlsWorkbookSourceCodeModule getWorkbookSourceCodeModule() {
        return (XlsWorkbookSourceCodeModule)this.getModule();
    }

    public WorksheetSyntaxNode[] getWorksheetSyntaxNodes() {
        return (WorksheetSyntaxNode[])this.getNodes();
    }
}

