/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.syntax;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.openl.util.StringTool;

public final class TableUtils {
    private TableUtils() {
    }

    public static String makeTableId(String uri) {
        return Optional.ofNullable(uri).map(StringTool::decodeURL).map(TableUtils::toCellURI).map(DigestUtils::md5Hex).orElse(null);
    }

    static String toCellURI(String rawUri) {
        int querySep = rawUri.indexOf(63);
        if (querySep > 0) {
            String rawQuery = rawUri.substring(querySep + 1);
            LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
            for (String string : rawQuery.split("&")) {
                int idx = string.indexOf(61);
                if (idx < 0) {
                    query.put(string, null);
                    continue;
                }
                query.put(string.substring(0, idx), string.substring(idx + 1));
            }
            if (query.containsKey("range")) {
                StringBuilder newUri = new StringBuilder();
                newUri.append(rawUri, 0, querySep).append('?');
                int idx = 0;
                for (Map.Entry entry : query.entrySet()) {
                    if (idx > 0) {
                        newUri.append('&');
                    }
                    if ("range".equals(entry.getKey())) {
                        newUri.append("cell").append('=');
                        String value = (String)entry.getValue();
                        newUri.append(value, 0, value.indexOf(58));
                    } else {
                        newUri.append((String)entry.getKey()).append('=').append((String)entry.getValue());
                    }
                    ++idx;
                }
                return newUri.toString();
            }
        }
        return rawUri;
    }
}

