/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.syntax;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.openl.meta.StringValue;
import org.openl.rules.annotations.Executable;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.syntax.HeaderSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableUtils;
import org.openl.rules.lang.xls.types.meta.EmptyMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.syntax.GridLocation;
import org.openl.rules.table.xls.XlsUrlParser;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.NaryNode;
import org.openl.types.IOpenMember;
import org.openl.util.text.ILocation;

public class TableSyntaxNode
extends NaryNode {
    public static final TableSyntaxNode[] EMPTY_ARRAY = new TableSyntaxNode[0];
    private ILogicalTable table;
    private final HeaderSyntaxNode headerNode;
    private ITableProperties tableProperties;
    private IOpenMember member;
    private final Map<String, ILogicalTable> subTables = new HashMap<String, ILogicalTable>();
    private Object validationResult;
    private MetaInfoReader metaInfoReader = EmptyMetaInfoReader.getInstance();
    private volatile String tableId;

    public TableSyntaxNode(String type, GridLocation pos, XlsSheetSourceCodeModule module, IGridTable gridTable, HeaderSyntaxNode header) {
        super(type, (ILocation)pos, null, (IOpenSourceCodeModule)module);
        this.table = LogicalTableHelper.logicalTable(gridTable);
        this.headerNode = header;
        header.setParent((ISyntaxNode)this);
    }

    public void setTable(IGridTable gridTable) {
        this.table = LogicalTableHelper.logicalTable(gridTable);
    }

    public String getDisplayName() {
        return this.table.getSource().getCell(0, 0).getStringValue();
    }

    public GridLocation getGridLocation() {
        return (GridLocation)this.getLocation();
    }

    public HeaderSyntaxNode getHeader() {
        return this.headerNode;
    }

    public StringValue getHeaderLineValue() {
        String value = this.table.getSource().getCell(0, 0).getStringValue();
        if (value == null) {
            return new StringValue("");
        }
        return new StringValue(value, value, value, (IOpenSourceCodeModule)new GridCellSourceCodeModule(this.table.getSource(), 0, 0, null));
    }

    public IOpenMember getMember() {
        return this.member;
    }

    public ITableProperties getTableProperties() {
        return this.tableProperties;
    }

    public Map<String, ILogicalTable> getSubTables() {
        return this.subTables;
    }

    public ILogicalTable getTable(String view) {
        return this.subTables.get(view);
    }

    public ILogicalTable getTable() {
        return this.table;
    }

    public IGridTable getGridTable() {
        return this.table.getSource();
    }

    public ILogicalTable getTableBody() {
        int startRow;
        int n = startRow = !this.hasPropertiesDefinedInTable() ? 1 : 2;
        if (this.table.getHeight() <= startRow) {
            return null;
        }
        return (ILogicalTable)this.table.getRows(startRow);
    }

    public String getUri() {
        return this.getGridTable().getUri();
    }

    public XlsUrlParser getUriParser() {
        return this.getGridTable().getUriParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId() {
        if (this.tableId == null) {
            TableSyntaxNode tableSyntaxNode = this;
            synchronized (tableSyntaxNode) {
                if (this.tableId == null) {
                    this.tableId = TableUtils.makeTableId(this.getUri());
                }
            }
        }
        return this.tableId;
    }

    public Object getValidationResult() {
        return this.validationResult;
    }

    public XlsSheetSourceCodeModule getXlsSheetSourceCodeModule() {
        return (XlsSheetSourceCodeModule)this.getModule();
    }

    public void setMember(IOpenMember member) {
        this.member = member;
    }

    public void setTableProperties(ITableProperties properties) {
        this.tableProperties = properties;
    }

    public void setValidationResult(Object validationResult) {
        this.validationResult = validationResult;
    }

    public boolean hasPropertiesDefinedInTable() {
        return this.tableProperties != null && this.tableProperties.getPropertiesSection() != null;
    }

    public boolean isExecutableNode() {
        if (this.getMember() != null) {
            Annotation[] annotations;
            Class<?> memberClass = this.getMember().getClass();
            for (Annotation annotation : annotations = memberClass.getAnnotations()) {
                if (!(annotation instanceof Executable)) continue;
                return true;
            }
        }
        return false;
    }

    public XlsNodeTypes getNodeType() {
        return XlsNodeTypes.getEnumByValue(this.getType());
    }

    public MetaInfoReader getMetaInfoReader() {
        return this.metaInfoReader;
    }

    public void setMetaInfoReader(MetaInfoReader metaInfoReader) {
        this.metaInfoReader = metaInfoReader;
    }
}

