/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.load;

import java.lang.ref.WeakReference;
import org.apache.poi.ss.usermodel.Cell;
import org.openl.rules.lang.xls.load.CellLoader;
import org.openl.rules.lang.xls.load.SheetLoader;
import org.openl.rules.table.xls.PoiExcelHelper;

public class LazyCellLoader
implements CellLoader {
    private final SheetLoader sheetLoader;
    private final int column;
    private final int row;
    private WeakReference<Cell> cellCache = new WeakReference<Object>(null);

    public LazyCellLoader(SheetLoader sheetLoader, int column, int row) {
        this.sheetLoader = sheetLoader;
        this.column = column;
        this.row = row;
    }

    @Override
    public Cell getCell() {
        if (this.cellCache == null) {
            return null;
        }
        Cell cell = (Cell)this.cellCache.get();
        if (cell == null) {
            cell = PoiExcelHelper.getCell(this.column, this.row, this.sheetLoader.getSheet());
            this.cellCache = cell == null ? null : new WeakReference<Cell>(cell);
        }
        return cell;
    }
}

