/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import java.util.Comparator;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.DimensionPropertiesMethodKey;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.types.IOpenMethod;
import org.openl.util.conf.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableVersionComparator
implements Comparator<ITableProperties> {
    private static final TableVersionComparator INSTANCE = new TableVersionComparator();
    private static final Version DEFAULT_VERSION = Version.parseVersion((String)"0.0.0", (int)0, (String)"..");

    public static TableVersionComparator getInstance() {
        return INSTANCE;
    }

    private TableVersionComparator() {
    }

    @Override
    public int compare(IOpenMethod first, IOpenMethod second) {
        if (!new DimensionPropertiesMethodKey(first).equals(new DimensionPropertiesMethodKey(second))) {
            throw new IllegalArgumentException("Incomparable tables. Tables should have similar name, signature and dimension properties.");
        }
        return this.compare(PropertiesHelper.getTableProperties(first), PropertiesHelper.getTableProperties(second));
    }

    @Override
    public int compare(TableSyntaxNode first, TableSyntaxNode second) {
        return this.compare(first.getTableProperties(), second.getTableProperties());
    }

    @Override
    public int compare(ITableProperties first, ITableProperties second) {
        Boolean secondActive;
        boolean firstActive = first.getActive() == null || first.getActive() != false;
        if (firstActive != (secondActive = Boolean.valueOf(second.getActive() == null || second.getActive() != false))) {
            return secondActive.compareTo(firstActive);
        }
        Version firstNodeVersion = TableVersionComparator.parseVersionForComparison(first.getVersion());
        Version secondNodeVersion = TableVersionComparator.parseVersionForComparison(second.getVersion());
        return secondNodeVersion.compareTo(firstNodeVersion);
    }

    private static Version parseVersionForComparison(String version) {
        if (version == null) {
            return DEFAULT_VERSION;
        }
        try {
            return Version.parseVersion((String)version, (int)0, (String)"..");
        }
        catch (RuntimeException e) {
            Logger log = LoggerFactory.getLogger(TableVersionComparator.class);
            log.debug("Failed to parse version: [{}]", (Object)version);
            return DEFAULT_VERSION;
        }
    }
}

