/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import org.openl.IOpenParser;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.code.impl.ParsedCode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;

public abstract class BaseParser
implements IOpenParser {
    public IParsedCode parseAsMethodBody(IOpenSourceCodeModule source) {
        return this.getNotSupportedCode(source, "a Method Body");
    }

    public IParsedCode parseAsMethodHeader(IOpenSourceCodeModule source) {
        return this.getNotSupportedCode(source, "a Method Header");
    }

    public IParsedCode parseAsModule(IOpenSourceCodeModule source) {
        return this.getNotSupportedCode(source, "a Module");
    }

    public IParsedCode parseAsType(IOpenSourceCodeModule source) {
        return this.getNotSupportedCode(source, "a Type");
    }

    public IParsedCode parseAsParameterDeclaration(IOpenSourceCodeModule source) {
        return this.getNotSupportedCode(source, "a param declaration");
    }

    protected IParsedCode getNotSupportedCode(IOpenSourceCodeModule source, String sourceType) {
        String message = String.format("The source cannot be parsed as %s", sourceType);
        return this.getInvalidCode(message, source);
    }

    protected IParsedCode getInvalidCode(String message, IOpenSourceCodeModule source) {
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)source);
        SyntaxNodeException[] errors = new SyntaxNodeException[]{error};
        return new ParsedCode(null, source, errors, null);
    }
}

