/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.beans.Transient;
import javax.xml.bind.annotation.XmlRootElement;
import org.openl.binding.impl.NumericComparableString;
import org.openl.binding.impl.NumericStringComparator;
import org.openl.rules.helpers.ARangeParser;
import org.openl.rules.helpers.StringRangeParser;
import org.openl.rules.range.Range;
import org.openl.rules.range.RangeParser;

@XmlRootElement
public class StringRange
extends Range<CharSequence> {
    private static final int TO_STRING_RANGE_CAST_DISTANCE = 38;
    private final Range.Type type;
    private final NumericComparableString lowerBound;
    private final NumericComparableString upperBound;

    StringRange(String lowerBound, String upperBound) {
        this(lowerBound, upperBound, ARangeParser.ParseStruct.BoundType.INCLUDING, ARangeParser.ParseStruct.BoundType.INCLUDING);
    }

    StringRange(String lowerBound, String upperBound, ARangeParser.ParseStruct.BoundType lowerBoundType, ARangeParser.ParseStruct.BoundType upperBoundType) {
        this.lowerBound = NumericComparableString.valueOf((String)lowerBound);
        this.upperBound = NumericComparableString.valueOf((String)upperBound);
        this.type = StringRangeParser.MAX_VALUE.equals(upperBound) ? (lowerBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? Range.Type.LEFT_OPEN : Range.Type.LEFT_CLOSED) : (StringRangeParser.MIN_VALUE.equals(lowerBound) ? (upperBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? Range.Type.RIGHT_OPEN : Range.Type.RIGHT_CLOSED) : (upperBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? (lowerBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? Range.Type.OPEN : Range.Type.CLOSED_OPEN) : (lowerBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? Range.Type.OPEN_CLOSED : Range.Type.CLOSED)));
        this.validate();
    }

    public StringRange(String source) {
        RangeParser rangeParser = this.parse(source);
        if (rangeParser == null) {
            this.type = Range.Type.DEGENERATE;
            this.upperBound = this.lowerBound = NumericComparableString.valueOf((String)source.trim());
        } else {
            this.type = rangeParser.getType();
            String left = rangeParser.getLeft();
            this.lowerBound = NumericComparableString.valueOf((String)(left == null ? StringRangeParser.MIN_VALUE : left));
            String right = rangeParser.getRight();
            this.upperBound = NumericComparableString.valueOf((String)(right == null ? StringRangeParser.MAX_VALUE : right));
            this.validate();
        }
    }

    public NumericComparableString getLowerBound() {
        return this.lowerBound;
    }

    public ARangeParser.ParseStruct.BoundType getLowerBoundType() {
        return this.type.left == Range.Bound.OPEN ? ARangeParser.ParseStruct.BoundType.EXCLUDING : ARangeParser.ParseStruct.BoundType.INCLUDING;
    }

    public NumericComparableString getUpperBound() {
        return this.upperBound;
    }

    public ARangeParser.ParseStruct.BoundType getUpperBoundType() {
        return this.type.right == Range.Bound.OPEN ? ARangeParser.ParseStruct.BoundType.EXCLUDING : ARangeParser.ParseStruct.BoundType.INCLUDING;
    }

    @Override
    public boolean contains(CharSequence value) {
        return super.contains(value);
    }

    @Override
    @Transient
    public Range.Type getType() {
        return this.type;
    }

    @Override
    protected CharSequence getLeft() {
        return this.lowerBound.getValue();
    }

    @Override
    protected CharSequence getRight() {
        return this.upperBound.getValue();
    }

    @Override
    protected int compare(CharSequence left, CharSequence right) {
        return NumericStringComparator.INSTANCE.compare(left, right);
    }

    public static StringRange autocast(String x, StringRange y) {
        return new StringRange(x);
    }

    public static int distance(String x, StringRange y) {
        return 38;
    }

    public static StringRange cast(char[] x, StringRange y) {
        return new StringRange(String.valueOf(x));
    }

    public static int distance(char[] x, StringRange y) {
        return 38;
    }
}

