/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.storage;

import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.ReadOnlyStorage;
import org.openl.rules.dt.storage.StorageInfo;

public class ScaledStorage
extends ReadOnlyStorage {
    private final DTScale.RowScale scale;
    private final IStorage s;

    ScaledStorage(DTScale.RowScale scale, IStorage s, StorageInfo info) {
        super(info);
        this.scale = scale;
        this.s = s;
    }

    @Override
    public int size() {
        return this.s.size() * this.scale.getMultiplier();
    }

    @Override
    public Object getValue(int index) {
        return this.s.getValue(this.actualIndex(index));
    }

    @Override
    public boolean isSpace(int index) {
        return this.s.isSpace(this.actualIndex(index));
    }

    @Override
    public boolean isFormula(int index) {
        return this.s.isFormula(this.actualIndex(index));
    }

    @Override
    public boolean isElse(int index) {
        return this.s.isElse(this.actualIndex(index));
    }

    private int actualIndex(int index) {
        return this.scale.getActualIndex(index);
    }
}

