/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm.evaluator;

import java.util.Objects;
import org.openl.domain.IDomain;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.algorithm.evaluator.DomainCanNotBeDefined;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.element.ConditionCasts;
import org.openl.types.IMethodCaller;
import org.openl.types.impl.ParameterMethodCaller;

public abstract class AConditionEvaluator
implements IConditionEvaluator {
    private String optimizedSourceCode;
    protected final ConditionCasts conditionCasts;

    public AConditionEvaluator(ConditionCasts conditionCasts) {
        this.conditionCasts = Objects.requireNonNull(conditionCasts, "conditionCasts cannot be null");
    }

    public IDomain<? extends Object> getRuleParameterDomain(IBaseCondition condition) throws DomainCanNotBeDefined {
        IMethodCaller mc = condition.getEvaluator();
        if (mc instanceof ParameterMethodCaller) {
            return this.indexedDomain(condition);
        }
        throw new DomainCanNotBeDefined("Not a Simple Expression", this.getFormalSourceCode(condition).getCode());
    }

    @Override
    public IDomain<?> getConditionParameterDomain(int paramIdx, IBaseCondition condition) throws DomainCanNotBeDefined {
        return this.indexedDomain(condition);
    }

    protected abstract IDomain<? extends Object> indexedDomain(IBaseCondition var1) throws DomainCanNotBeDefined;

    @Override
    public String getOptimizedSourceCode() {
        return this.optimizedSourceCode;
    }

    @Override
    public void setOptimizedSourceCode(String optimizedSourceCode) {
        this.optimizedSourceCode = optimizedSourceCode;
    }
}

