/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm;

import java.util.ArrayList;
import java.util.Iterator;
import org.openl.domain.AIntIterator;
import org.openl.domain.IIntIterator;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.vm.IRuntimeEnv;

public class TwoDimensionalAlgorithm
implements IDecisionTableAlgorithm {
    private final IDecisionTableAlgorithm va;
    private final IDecisionTableAlgorithm ha;

    TwoDimensionalAlgorithm(IDecisionTableAlgorithm va, IDecisionTableAlgorithm ha) {
        this.va = va;
        this.ha = ha;
    }

    @Override
    public void cleanParamValuesForIndexedConditions() {
        this.va.cleanParamValuesForIndexedConditions();
        this.ha.cleanParamValuesForIndexedConditions();
    }

    @Override
    public IIntIterator checkedRules(Object target, Object[] params, IRuntimeEnv env) {
        IIntIterator iv = this.va.checkedRules(target, params, env);
        IIntIterator ih = this.ha.checkedRules(target, params, env);
        return ih.isResetable() ? new TwoDScaleIterator(iv, ih) : new TwoDScaleIteratorNotResetable(iv, ih);
    }

    static class TwoDScaleIteratorNotResetable
    extends TwoDScaleIterator {
        final ArrayList<Integer> storeIh = new ArrayList();
        Iterator<Integer> itH;

        TwoDScaleIteratorNotResetable(IIntIterator iv, IIntIterator ih) {
            super(iv, ih);
        }

        @Override
        protected int nextH() {
            if (this.itH != null) {
                return this.itH.next();
            }
            int i = this.ih.nextInt();
            this.storeIh.add(i);
            return i;
        }

        @Override
        protected void resetH() {
            this.itH = this.storeIh.iterator();
        }

        @Override
        protected boolean hasNextH() {
            return this.itH == null ? this.ih.hasNext() : this.itH.hasNext();
        }
    }

    static class TwoDScaleIterator
    extends AIntIterator {
        final IIntIterator iv;
        final IIntIterator ih;
        int vValue = -1;

        TwoDScaleIterator(IIntIterator iv, IIntIterator ih) {
            this.iv = iv;
            this.ih = ih;
            this.nextV();
        }

        void nextV() {
            this.vValue = this.iv.hasNext() ? (Integer)this.iv.next() : -1;
        }

        public int nextInt() {
            return this.vValue + this.nextH();
        }

        protected int nextH() {
            return this.ih.nextInt();
        }

        public boolean hasNext() {
            while (this.vValue >= 0) {
                if (this.hasNextH()) {
                    return true;
                }
                this.resetH();
                this.nextV();
            }
            return false;
        }

        protected void resetH() {
            this.ih.reset();
        }

        protected boolean hasNextH() {
            return this.ih.hasNext();
        }

        public boolean isResetable() {
            return false;
        }

        public void reset() {
            throw new UnsupportedOperationException();
        }
    }
}

