/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import java.util.List;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.DecisionTableColumnHeaders;
import org.openl.rules.dt.DecisionTableHelper;
import org.openl.rules.dt.LookupHeadersTransformer;
import org.openl.rules.table.CoordinatesTransformer;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.TransformedGridTable;
import org.openl.util.ParserUtils;

public class DecisionTableLookupConvertor {
    private static final int HEADER_ROW = 0;
    private static final int DISPLAY_ROW = 3;
    private final List<IGridTable> hcHeaders = new ArrayList<IGridTable>();
    private IGridTable retTable;
    private DTScale scale;

    IGridTable convertTable(ILogicalTable table) throws OpenLCompilationException {
        ILogicalTable headerRow = (ILogicalTable)table.getRow(0);
        int firstLookupColumn = this.findFirstLookupColumn(headerRow);
        this.loadHorizConditionsAndReturnColumns(headerRow, firstLookupColumn);
        this.validateLookupSection();
        this.processHorizConditionsHeaders(table, firstLookupColumn);
        IGridTable lookupValuesTable = this.getLookupValuesTable(table, firstLookupColumn).getSource();
        Integer lookupValuesTableHeight = this.getLookupValuesTableHeight(table);
        this.isMultiplier(lookupValuesTable);
        CoordinatesTransformer transformer = this.getTransformer(table, headerRow, lookupValuesTable, lookupValuesTableHeight);
        return new TransformedGridTable(table.getSource(), transformer);
    }

    private CoordinatesTransformer getTransformer(ILogicalTable table, ILogicalTable headerRow, IGridTable lookupValuesTable, Integer lookupValuesTableHeight) throws OpenLCompilationException {
        this.validateRetColumn(headerRow);
        int retTableWidth = this.retTable.getCell(0, 0).getWidth();
        if (lookupValuesTableHeight == null) {
            lookupValuesTableHeight = lookupValuesTable.getHeight();
        }
        this.scale = new DTScale(lookupValuesTableHeight, lookupValuesTable.getWidth() / retTableWidth);
        return new LookupHeadersTransformer(table.getSource(), lookupValuesTable, retTableWidth, this.firstVerticalColumn(headerRow), this.buildHorizontalHeaderOffsets(headerRow));
    }

    private int firstVerticalColumn(ILogicalTable headerRow) {
        for (int columnIndex = 0; columnIndex < headerRow.getSource().getWidth(); ++columnIndex) {
            String headerStr = headerRow.getSource().getCell(columnIndex, 0).getStringValue();
            if (headerStr == null || !DecisionTableHelper.isValidRetHeader(headerStr = headerStr.toUpperCase()) && !DecisionTableHelper.isValidCRetHeader(headerStr) && !DecisionTableHelper.isValidHConditionHeader(headerStr)) continue;
            return columnIndex;
        }
        throw new IllegalStateException("Unexpected table structure");
    }

    private int[] buildHorizontalHeaderOffsets(ILogicalTable headerRow) {
        ICell cell;
        ArrayList<Integer> hcOffsets = new ArrayList<Integer>();
        ArrayList<Integer> retOffsets = new ArrayList<Integer>();
        for (int columnIndex = 0; columnIndex < headerRow.getSource().getWidth(); columnIndex += cell.getWidth()) {
            cell = headerRow.getSource().getCell(columnIndex, 0);
            String headerStr = cell.getStringValue();
            if (headerStr == null) continue;
            if (DecisionTableHelper.isValidHConditionHeader(headerStr = headerStr.toUpperCase())) {
                hcOffsets.add(columnIndex);
                continue;
            }
            if (!DecisionTableHelper.isValidRetHeader(headerStr) && !DecisionTableHelper.isValidCRetHeader(headerStr)) continue;
            retOffsets.add(columnIndex);
        }
        hcOffsets.addAll(retOffsets);
        return hcOffsets.stream().mapToInt(Integer::intValue).toArray();
    }

    private void validateRetColumn(ILogicalTable headerRow) throws OpenLCompilationException {
        int ncol = headerRow.getSource().getWidth();
        for (int columnIndex = 0; columnIndex < ncol; ++columnIndex) {
            String headerStr = headerRow.getSource().getCell(columnIndex, 0).getStringValue();
            if (headerStr == null || !DecisionTableHelper.isValidRetHeader(headerStr = headerStr.toUpperCase()) && !DecisionTableHelper.isValidCRetHeader(headerStr)) continue;
            return;
        }
        throw new OpenLCompilationException("RET or CRET column is mandatory for Lookup table.");
    }

    private void processHorizConditionsHeaders(ILogicalTable originalTable, int firstLookupColumn) throws OpenLCompilationException {
        ILogicalTable hcRowTable = (ILogicalTable)((ILogicalTable)originalTable.getRows(3)).getRow(0);
        int w = 0;
        int c = 0;
        while (w < firstLookupColumn) {
            w += ((ILogicalTable)hcRowTable.getColumn(c)).getSource().getWidth();
            ++c;
        }
        ILogicalTable hcHeaderTable = (ILogicalTable)hcRowTable.getSubtable(c, 0, hcRowTable.getWidth() - c, hcRowTable.getHeight());
        this.validateHCHeaders(hcHeaderTable);
    }

    private ILogicalTable getLookupValuesTable(ILogicalTable originalTable, int firstLookupColumn) {
        int w = 0;
        int c = 0;
        while (w < firstLookupColumn) {
            w += ((ILogicalTable)originalTable.getColumn(c)).getSource().getWidth();
            ++c;
        }
        ILogicalTable hcRowTable = (ILogicalTable)((ILogicalTable)originalTable.getRows(3)).getRow(0);
        return (ILogicalTable)originalTable.getSubtable(c, 3 + hcRowTable.getHeight(), originalTable.getWidth() - c, originalTable.getHeight() - hcRowTable.getHeight() - 3);
    }

    private Integer getLookupValuesTableHeight(ILogicalTable originalTable) {
        String stringValue = originalTable.getCell(0, 0).getStringValue();
        if (stringValue == null) {
            stringValue = "";
        }
        stringValue = stringValue.toUpperCase();
        ILogicalTable valueTable = (ILogicalTable)originalTable.getRows(4);
        if (DecisionTableHelper.isValidRuleHeader(stringValue) || DecisionTableHelper.isValidMergedConditionHeader(stringValue)) {
            return valueTable.getHeight();
        }
        return null;
    }

    private int getWidthWithIgnoredEmptyCells(IGridTable table) {
        for (int width = table.getWidth(); width > 0; --width) {
            for (int i = 0; i < table.getHeight(); ++i) {
                if (table.getCell(width - 1, 0).getStringValue() == null) continue;
                return width;
            }
        }
        return 0;
    }

    private void isMultiplier(IGridTable lookupValuesTable) throws OpenLCompilationException {
        boolean isMultiplier;
        int retTableWidth = this.retTable.getWidth();
        int lookupTableWidth = lookupValuesTable.getWidth();
        boolean bl = isMultiplier = lookupTableWidth % retTableWidth == 0;
        if (!isMultiplier) {
            int w = this.getWidthWithIgnoredEmptyCells(lookupValuesTable);
            boolean bl2 = isMultiplier = w % retTableWidth == 0;
            if (!isMultiplier) {
                String message = String.format("The width of the Lookup table(%d) is not a multiple of the RET width(%d).", lookupTableWidth, retTableWidth);
                throw new OpenLCompilationException(message);
            }
        }
    }

    private void validateHCHeaders(ILogicalTable hcHeaderTable) throws OpenLCompilationException {
        if (this.hcHeaders.size() != hcHeaderTable.getSource().getHeight()) {
            throw new OpenLCompilationException("The height of the horizontal keys must be equal to the number of the horizontal headers.");
        }
    }

    private int findFirstLookupColumn(ILogicalTable headerRow) throws OpenLCompilationException {
        int ncol = headerRow.getSource().getWidth();
        for (int columnIndex = 0; columnIndex < ncol; ++columnIndex) {
            String headerStr = ((IGridTable)headerRow.getSource().getColumn(columnIndex)).getCell(0, 0).getStringValue();
            if (headerStr == null || DecisionTableHelper.isValidRuleHeader(headerStr = headerStr.toUpperCase()) || DecisionTableHelper.isValidConditionHeader(headerStr) || DecisionTableHelper.isValidMergedConditionHeader(headerStr) || ParserUtils.isBlankOrCommented((String)headerStr)) continue;
            return columnIndex;
        }
        throw new OpenLCompilationException("Horizontal condition is mandatory for Lookup table.");
    }

    private void loadHorizConditionsAndReturnColumns(ILogicalTable rowHeader, int firstLookupColumn) throws OpenLCompilationException {
        IGridTable hTable;
        int nCol = rowHeader.getSource().getWidth();
        for (int d = 0; d < nCol; d += hTable.getCell(0, 0).getWidth()) {
            String headerStr;
            hTable = (IGridTable)rowHeader.getSource().getColumn(d);
            if (d < firstLookupColumn || (headerStr = hTable.getCell(0, 0).getStringValue()) == null) continue;
            if (DecisionTableHelper.isValidHConditionHeader(headerStr = headerStr.toUpperCase())) {
                if (hTable.getWidth() != 1) {
                    throw new OpenLCompilationException("Column HC must have width = 1.");
                }
                this.hcHeaders.add(hTable);
                continue;
            }
            if (DecisionTableHelper.isValidRetHeader(headerStr) || DecisionTableHelper.isValidCRetHeader(headerStr)) {
                if (this.retTable != null) {
                    throw new OpenLCompilationException("Only one RET column is allowed for Lookup table.");
                }
                this.retTable = hTable;
                continue;
            }
            throw new OpenLCompilationException("Lookup Table allows only HC or RET or CRET columns after vertical conditions: " + headerStr);
        }
    }

    private void validateLookupSection() throws OpenLCompilationException {
        if (this.hcHeaders.isEmpty()) {
            String message = String.format("Horizontal Condition (%s1) is mandatory for Lookup table.", DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey());
            throw new OpenLCompilationException(message);
        }
        if (this.retTable == null) {
            String message = String.format("Lookup Table must have %s column", DecisionTableColumnHeaders.RETURN.getHeaderKey());
            throw new OpenLCompilationException(message);
        }
    }

    public DTScale getScale() {
        return this.scale;
    }
}

