/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.engine.OpenLManager;
import org.openl.message.OpenLMessagesUtils;
import org.openl.meta.IMetaInfo;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.datatype.binding.AliasDatatypeBoundNode;
import org.openl.rules.datatype.binding.DatatypeHelper;
import org.openl.rules.datatype.binding.DatatypeTableBoundNode;
import org.openl.rules.lang.xls.binding.AXlsTableBinder;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.DatatypeMetaInfo;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.table.ILogicalTable;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.CompositeOpenlException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ArrayTool;
import org.openl.util.TableNameChecker;

public class DatatypeNodeBinder
extends AXlsTableBinder {
    public static final int PARENT_TYPE_INDEX = 3;
    public static final int TYPE_INDEX = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMemberBoundNode preBind(TableSyntaxNode tsn, OpenL openl, RulesModuleBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        IOpenClass openClass;
        ILogicalTable table = tsn.getTable();
        IOpenSourceCodeModule tableSource = tsn.getHeader().getModule();
        IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)tableSource, (String)" \n\r");
        if (parsedHeader.length < 2) {
            String message1 = "Datatype table format: Datatype <typename>";
            throw SyntaxNodeExceptionUtils.createError((String)message1, null, null, (IOpenSourceCodeModule)tableSource);
        }
        String typeName = parsedHeader[1].getIdentifier();
        if (TableNameChecker.isInvalidJavaIdentifier((String)typeName)) {
            String message = String.format("%s '%s' name error. Name can only have letters, digits, _, $ and should not start with a digit.", "Datatype table", typeName);
            bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)message, (ISyntaxNode)parsedHeader[1]));
        }
        try {
            bindingContext.pushErrors();
            bindingContext.pushMessages();
            openClass = bindingContext.findType("org.openl.this", typeName);
        }
        finally {
            bindingContext.popErrors();
            bindingContext.popMessages();
        }
        String packageName = tsn.getTableProperties().getPropertyValueAsString("datatypePackage");
        if (openClass != null && !(openClass instanceof JavaOpenClass) && openClass.getPackageName().equals(packageName)) {
            String message = "Duplicate type definition: " + typeName;
            throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)parsedHeader[1]);
        }
        DatatypeNodeBinder.putSubTableForBusinessView(tsn);
        if (parsedHeader.length == 3 && parsedHeader[2] != null && parsedHeader[2].getIdentifier().startsWith("<") && parsedHeader[2].getIdentifier().endsWith(">")) {
            OpenlToolAdaptor openlAdaptor;
            IOpenClass arrayOpenClass;
            Object values;
            IOpenClass baseOpenClass;
            int beginIndex = 1;
            int endIndex = parsedHeader[2].getIdentifier().length() - 1;
            ILogicalTable dataPart = DatatypeHelper.getNormalizedDataPartTable(table, openl, (IBindingContext)bindingContext);
            String type = parsedHeader[2].getOriginalText().substring(beginIndex, endIndex).trim();
            try {
                bindingContext.pushErrors();
                bindingContext.pushMessages();
                baseOpenClass = OpenLManager.makeType((OpenL)bindingContext.getOpenL(), (String)type, (IOpenSourceCodeModule)tableSource, (IBindingContext)bindingContext);
                if (bindingContext.getErrors().length > 0) {
                    if (bindingContext.getErrors().length == 1) {
                        throw bindingContext.getErrors()[0];
                    }
                    throw new CompositeOpenlException("Binding Errors:", bindingContext.getErrors(), bindingContext.getMessages());
                }
            }
            finally {
                bindingContext.popErrors();
                bindingContext.popMessages();
            }
            Object[] res = new Object[]{};
            if (dataPart != null && (values = RuleRowHelper.loadParam(dataPart, arrayOpenClass = baseOpenClass.getArrayType(1), "Values", "", openlAdaptor = new OpenlToolAdaptor(openl, (IBindingContext)bindingContext, tsn), true)) != null) {
                res = ArrayTool.toArray((Object)values);
            }
            EnumDomain domain = new EnumDomain(res);
            DomainOpenClass tableType = new DomainOpenClass(typeName, baseOpenClass, (IDomain)domain, (ModuleOpenClass)module, (IMetaInfo)new DatatypeMetaInfo(tableSource.getCode(), tsn.getUri()));
            bindingContext.addType("org.openl.this", (IOpenClass)tableType);
            return new AliasDatatypeBoundNode(tsn, tableType, module);
        }
        if (parsedHeader.length != 2 && parsedHeader.length != 4 || parsedHeader.length == 4 && !parsedHeader[2].getIdentifier().equals("extends")) {
            String message = "Datatype table formats: [Datatype %typename%] or [Datatype %typename% extends %parentTypeName%] or [Datatype %typename% %<aliastype>%] ";
            throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)tableSource);
        }
        DatatypeOpenClass tableType = new DatatypeOpenClass(typeName, packageName);
        tableType.setModule(module);
        if (!bindingContext.isExecutionMode()) {
            tableType.setTableSyntaxNode(tsn);
        }
        tableType.setMetaInfo(new DatatypeMetaInfo(tableSource.getCode(), tsn.getUri()));
        bindingContext.addType("org.openl.this", (IOpenClass)tableType);
        if (parsedHeader.length == 4) {
            return new DatatypeTableBoundNode(tsn, tableType, module, table, openl, parsedHeader[3]);
        }
        return new DatatypeTableBoundNode(tsn, tableType, module, table, openl);
    }

    private static void putSubTableForBusinessView(TableSyntaxNode tsn) {
        tsn.getSubTables().put("business", tsn.getTableBody());
    }
}

