/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.engine.OpenLManager;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;
import org.openl.util.StringUtils;

public class DatatypeHelper {
    private static final int MAXIMUM_COLUMNS_COUNT = 3;
    private static final int TYPE_NAME_COLUMN = 0;
    private static final int FIELD_NAME_COLUMN = 1;
    private static final int DEFAULTS_COLUMN = 2;

    public static ILogicalTable getNormalizedDataPartTable(ILogicalTable table, OpenL openl, IBindingContext cxt) {
        ILogicalTable dataPart = PropertiesHelper.getPropertiesTableSection(table) != null ? (ILogicalTable)table.getRows(2) : (ILogicalTable)table.getRows(1);
        if (dataPart == null) {
            return null;
        }
        if (dataPart.getHeight() == 1) {
            return dataPart;
        }
        if (dataPart.getWidth() == 1) {
            return (ILogicalTable)dataPart.transpose();
        }
        if (dataPart.getHeight() > 3) {
            return dataPart;
        }
        if (dataPart.getWidth() > 3) {
            return (ILogicalTable)dataPart.transpose();
        }
        if (dataPart.getWidth() == 3 && DatatypeHelper.isThirdColumnForDefaults(dataPart)) {
            return dataPart;
        }
        if (dataPart.getHeight() == 3 && DatatypeHelper.isThirdColumnForDefaults((ILogicalTable)dataPart.transpose())) {
            return (ILogicalTable)dataPart.transpose();
        }
        int verticalCount = DatatypeHelper.countTypes(dataPart, openl, cxt);
        if (verticalCount == dataPart.getHeight() && verticalCount >= dataPart.getWidth()) {
            return dataPart;
        }
        int horizontalCount = DatatypeHelper.countTypes((ILogicalTable)dataPart.transpose(), openl, cxt);
        if (verticalCount < horizontalCount) {
            return (ILogicalTable)dataPart.transpose();
        }
        return dataPart;
    }

    private static boolean isThirdColumnForDefaults(ILogicalTable table) {
        return DatatypeHelper.isDefault(table.getCell(2, 0)) || DatatypeHelper.isDefault(table.getCell(2, 1));
    }

    private static boolean isDefault(ICell cell) {
        String value = cell.getStringValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        char firstChar = value.charAt(0);
        return '0' <= firstChar && firstChar <= '9';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int countTypes(ILogicalTable table, OpenL openl, IBindingContext cxt) {
        int height = table.getHeight();
        int count = 1;
        cxt.pushErrors();
        try {
            for (int i = 1; i < height; ++i) {
                IOpenClass type;
                ILogicalTable row = (ILogicalTable)table.getRow(i);
                GridCellSourceCodeModule source = new GridCellSourceCodeModule(row.getSource(), cxt);
                String code = row.getCell(0, 0).getStringValue();
                if (StringUtils.isBlank((CharSequence)code) || (type = OpenLManager.makeType((OpenL)cxt.getOpenL(), (String)code, (IOpenSourceCodeModule)source, (IBindingContext)cxt)) == NullOpenClass.the) continue;
                ++count;
            }
        }
        finally {
            cxt.popErrors();
        }
        return count;
    }
}

