/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.openl.rules.convertor.IObjectToDataConvertor;
import org.openl.rules.convertor.LocaleDependConvertor;
import org.openl.rules.helpers.IntRange;
import org.openl.util.RuntimeExceptionWrapper;

public class ObjectToDataConvertorFactory {
    private static final Map<ClassCastPair, IObjectToDataConvertor> converters = new ConcurrentHashMap<ClassCastPair, IObjectToDataConvertor>();
    public static final IObjectToDataConvertor NO_Convertor;

    public static IObjectToDataConvertor getConvertor(Class<?> toClass, Class<?> fromClass) {
        Constructor ctr;
        if (toClass == fromClass) {
            return CopyConvertor.the;
        }
        ClassCastPair pair = new ClassCastPair(fromClass, toClass);
        IObjectToDataConvertor convertor = converters.get(pair);
        if (convertor != null) {
            return convertor;
        }
        Method method = ObjectToDataConvertorFactory.getValueOfMethod(toClass, fromClass);
        convertor = method != null ? new StaticMethodConvertor(method) : ((ctr = ConstructorUtils.getMatchingAccessibleConstructor(toClass, (Class[])new Class[]{fromClass})) != null ? new MatchedConstructorConvertor(ctr) : NO_Convertor);
        converters.put(pair, convertor);
        return convertor;
    }

    private static Method getValueOfMethod(Class<?> toClass, Class<?> fromClass) {
        if (fromClass == null) {
            return null;
        }
        Method method = MethodUtils.getAccessibleMethod(toClass, (String)"valueOf", (Class[])new Class[]{fromClass});
        return method == null ? MethodUtils.getAccessibleMethod(toClass, (String)"valueOf", (Class[])new Class[]{Object.class}) : method;
    }

    public static IObjectToDataConvertor registerConvertor(Class<?> toClass, Class<?> fromClass, IObjectToDataConvertor convertor) {
        ClassCastPair pair = new ClassCastPair(fromClass, toClass);
        return converters.put(pair, convertor);
    }

    static {
        try {
            converters.put(new ClassCastPair(Integer.class, IntRange.class), e -> new IntRange(((Integer)e).intValue()));
            converters.put(new ClassCastPair(Integer.TYPE, IntRange.class), e -> new IntRange(((Integer)e).intValue()));
            converters.put(new ClassCastPair(Double.class, Double.TYPE), CopyConvertor.the);
            converters.put(new ClassCastPair(Double.TYPE, Double.class), CopyConvertor.the);
            converters.put(new ClassCastPair(Integer.TYPE, Integer.class), CopyConvertor.the);
            converters.put(new ClassCastPair(Integer.class, Integer.TYPE), CopyConvertor.the);
            converters.put(new ClassCastPair(Date.class, Calendar.class), e -> {
                Calendar cal = Calendar.getInstance(LocaleDependConvertor.getLocale());
                cal.setTime((Date)e);
                return cal;
            });
            converters.put(new ClassCastPair(Date.class, LocalDate.class), e -> Instant.ofEpochMilli(((Date)e).getTime()).atZone(ZoneId.systemDefault()).toLocalDate());
            converters.put(new ClassCastPair(Date.class, ZonedDateTime.class), e -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(((Date)e).getTime()), ZoneId.systemDefault()));
            converters.put(new ClassCastPair(Date.class, Instant.class), e -> ((Date)e).toInstant());
            converters.put(new ClassCastPair(Date.class, LocalTime.class), e -> Instant.ofEpochMilli(((Date)e).getTime()).atZone(ZoneId.systemDefault()).toLocalTime());
            converters.put(new ClassCastPair(Date.class, LocalDateTime.class), e -> Instant.ofEpochMilli(((Date)e).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        NO_Convertor = e -> new UnsupportedOperationException();
    }

    public static class CopyConvertor
    implements IObjectToDataConvertor {
        public static final CopyConvertor the = new CopyConvertor();

        @Override
        public Object convert(Object data) {
            return data;
        }
    }

    public static class StaticMethodConvertor
    implements IObjectToDataConvertor {
        private final Method staticMethod;

        public StaticMethodConvertor(Method staticMethod) {
            if (!Modifier.isStatic(staticMethod.getModifiers())) {
                throw new IllegalArgumentException("Income method should be static");
            }
            this.staticMethod = staticMethod;
        }

        @Override
        public Object convert(Object data) {
            try {
                return this.staticMethod.invoke(null, data);
            }
            catch (Exception e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }
    }

    public static class MatchedConstructorConvertor
    implements IObjectToDataConvertor {
        private final Constructor<?> ctr;

        public MatchedConstructorConvertor(Constructor<?> ctr) {
            this.ctr = ctr;
        }

        @Override
        public Object convert(Object data) {
            try {
                return this.ctr.newInstance(data);
            }
            catch (Exception e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }
    }

    public static class ClassCastPair {
        private final Class<?> from;
        private final Class<?> to;

        public ClassCastPair(Class<?> from, Class<?> to) {
            this.from = from;
            this.to = to;
        }

        public Class<?> getFrom() {
            return this.from;
        }

        public Class<?> getTo() {
            return this.to;
        }

        public int hashCode() {
            return this.to.hashCode() + this.from.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassCastPair)) {
                return false;
            }
            ClassCastPair pair = (ClassCastPair)obj;
            return this.from == pair.from && this.to == pair.to;
        }
    }
}

