/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cmatch;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openl.rules.cmatch.algorithm.Argument;
import org.openl.rules.cmatch.matcher.IMatcher;

public class MatchNode {
    private final List<MatchNode> children = new LinkedList<MatchNode>();
    private final int rowIndex;
    private MatchNode parent;
    private IMatcher matcher;
    private Argument argument;
    private int weight;
    private Object[] checkValues;

    public MatchNode(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void add(MatchNode child) {
        this.children.add(child);
        child.parent = this;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public Argument getArgument() {
        return this.argument;
    }

    public Object[] getCheckValues() {
        return this.checkValues;
    }

    public List<MatchNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public IMatcher getMatcher() {
        return this.matcher;
    }

    public MatchNode getParent() {
        return this.parent;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public void setArgument(Argument argument) {
        this.argument = argument;
    }

    public void setCheckValues(Object[] checkValues) {
        this.checkValues = checkValues;
    }

    public void setMatcher(IMatcher matcher) {
        this.matcher = matcher;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }
}

