/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cmatch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openl.binding.IBindingContext;
import org.openl.meta.StringValue;
import org.openl.rules.cmatch.ColumnMatch;
import org.openl.rules.cmatch.SubValue;
import org.openl.rules.cmatch.TableColumn;
import org.openl.rules.cmatch.TableRow;
import org.openl.rules.cmatch.algorithm.IMatchAlgorithmCompiler;
import org.openl.rules.cmatch.algorithm.MatchAlgorithmFactory;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;

public class ColumnMatchBuilder {
    private final IBindingContext bindingContext;
    private final ColumnMatch columnMatch;
    private final TableSyntaxNode tsn;
    private List<TableColumn> columns;

    public ColumnMatchBuilder(IBindingContext ctx, ColumnMatch columnMatch, TableSyntaxNode tsn) {
        this.bindingContext = ctx;
        this.columnMatch = columnMatch;
        this.tsn = tsn;
    }

    public void build(ILogicalTable tableBody) throws SyntaxNodeException {
        IMatchAlgorithmCompiler algorithm;
        if (tableBody.getHeight() < 4) {
            throw SyntaxNodeExceptionUtils.createError((String)"Insufficient rows. At least 4 are expected.", null, (ISyntaxNode)this.tsn);
        }
        this.prepareColumns(tableBody);
        List<TableRow> rows = this.buildRows(tableBody);
        this.columnMatch.setColumns(this.columns);
        this.columnMatch.setRows(rows);
        IOpenSourceCodeModule alg = this.columnMatch.getAlgorithm();
        String nameOfAlgorithm = alg != null ? alg.getCode() : null;
        try {
            algorithm = MatchAlgorithmFactory.getAlgorithm(nameOfAlgorithm);
        }
        catch (Exception | LinkageError ex) {
            throw SyntaxNodeExceptionUtils.createError((Throwable)ex, (ISyntaxNode)this.columnMatch.getSyntaxNode());
        }
        algorithm.compile(this.bindingContext, this.columnMatch);
    }

    private List<TableRow> buildRows(ILogicalTable tableBody) throws SyntaxNodeException {
        ILogicalTable leftRows = (ILogicalTable)((ILogicalTable)tableBody.getColumn(0)).getRows(2);
        int dataRowsCount = leftRows.getHeight();
        ArrayList<TableRow> rows = new ArrayList<TableRow>(dataRowsCount);
        for (int i = 0; i < dataRowsCount; ++i) {
            rows.add(new TableRow());
        }
        for (TableColumn column : this.columns) {
            ILogicalTable data;
            ILogicalTable colTable = (ILogicalTable)tableBody.getSubtable(column.getColumnIndex(), 2, 1, 1);
            if (column.getColumnIndex() == 0) {
                if (colTable.getWidth() != 1) {
                    throw SyntaxNodeExceptionUtils.createError((String)"First column must have width=1.", null, (ISyntaxNode)this.tsn);
                }
                data = (ILogicalTable)leftRows.getRows(1);
            } else {
                data = LogicalTableHelper.mergeBounds(leftRows, colTable);
            }
            int subColumns = data.getWidth();
            IGridTable grid = data.getSource();
            for (int r = 0; r < data.getHeight(); ++r) {
                SubValue[] values = this.createSV(column, grid, r, subColumns);
                ((TableRow)rows.get(r + 1)).add(column.getId(), values);
            }
            grid = colTable.getSource();
            SubValue[] values = this.createSV(column, grid, 0, subColumns);
            ((TableRow)rows.get(0)).add(column.getId(), values);
        }
        return rows;
    }

    private SubValue[] createSV(TableColumn column, IGridTable grid, int r, int subColumns) {
        SubValue[] values = new SubValue[subColumns];
        for (int c = 0; c < subColumns; ++c) {
            String value = grid.getCell(c, r).getStringValue();
            value = value == null ? "" : value.trim();
            String cellName = "cell" + r + "_" + column.getColumnIndex() + "_" + c;
            StringValue sv = new StringValue(value, cellName, cellName, (IOpenSourceCodeModule)new GridCellSourceCodeModule(grid, c, r, this.bindingContext));
            values[c] = new SubValue(sv, grid.getCell(c, r).getStyle());
            IGridTable lr = (IGridTable)grid.getSubtable(c, r, 1, 1);
            values[c].setGridRegion(lr.getRegion());
        }
        return values;
    }

    private void prepareColumns(ILogicalTable tableBody) throws SyntaxNodeException {
        this.columns = new ArrayList<TableColumn>();
        HashSet<String> addedIds = new HashSet<String>();
        ILogicalTable ids = (ILogicalTable)tableBody.getRow(0);
        for (int c = 0; c < ids.getWidth(); ++c) {
            String id = ColumnMatchBuilder.safeId(((ILogicalTable)ids.getColumn(c)).getSource().getCell(0, 0).getStringValue());
            if (id.length() == 0) continue;
            if (addedIds.contains(id)) {
                throw SyntaxNodeExceptionUtils.createError((String)("Duplicate column '" + id + "'."), null, (ISyntaxNode)this.tsn);
            }
            this.columns.add(new TableColumn(id, c));
            addedIds.add(id);
        }
    }

    private static String safeId(String s) {
        if (s == null) {
            return "";
        }
        return s.trim().toLowerCase();
    }
}

