/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.Map;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.element.SpreadsheetCellField;
import org.openl.rules.calc.element.SpreadsheetCellType;
import org.openl.types.IDynamicObject;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.Invokable;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.Tracer;

public class SpreadsheetResultCalculator
implements IDynamicObject {
    public static final Object METHOD_VALUE = new Object();
    public static final Object EMPTY_CELL = new Object();
    private final Spreadsheet spreadsheet;
    protected final IDynamicObject targetModule;
    protected final Object[] params;
    protected final IRuntimeEnv env;
    private final Object[][] results;

    public SpreadsheetResultCalculator(Spreadsheet spreadsheet, IDynamicObject targetModule, Object[] params, IRuntimeEnv env, Object[][] preCalculatedResult) {
        this.spreadsheet = spreadsheet;
        this.targetModule = targetModule;
        this.params = params;
        this.env = env;
        this.results = preCalculatedResult == null ? new Object[spreadsheet.getHeight()][spreadsheet.getWidth()] : this.clonePrecalculatedResults(preCalculatedResult);
    }

    private Object[][] clonePrecalculatedResults(Object[][] preCalculatedResult) {
        Object[][] res = (Object[][])preCalculatedResult.clone();
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Object[])preCalculatedResult[i].clone();
        }
        return res;
    }

    public Object getFieldValue(String name) {
        IOpenField field = this.spreadsheet.getSpreadsheetType().getField(name);
        if (field == null) {
            return this.targetModule.getFieldValue(name);
        }
        SpreadsheetCellField cellField = (SpreadsheetCellField)field;
        int row = cellField.getCell().getRowIndex();
        int column = cellField.getCell().getColumnIndex();
        return this.getValue(row, column);
    }

    public Map<String, Object> getFieldValues() {
        throw new UnsupportedOperationException("Should not be called, this is only used in NicePrinter");
    }

    public Object getRow(int row, IRuntimeEnv env) {
        return null;
    }

    public Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    public IOpenClass getType() {
        return this.spreadsheet.getSpreadsheetType();
    }

    public Object getValue(int row, int column) {
        Object result = this.results[row][column];
        if (result == EMPTY_CELL) {
            return null;
        }
        SpreadsheetCell spreadsheetCell = this.spreadsheet.getCells()[row][column];
        if (result != METHOD_VALUE) {
            if (spreadsheetCell.getSpreadsheetCellType() == SpreadsheetCellType.METHOD) {
                Tracer.resolveTraceNode((Invokable)spreadsheetCell, (Object)this, (Object[])this.params, (IRuntimeEnv)this.env, (Object)this);
            } else {
                Tracer.put((Object)spreadsheetCell, (String)"cell", (Object)result);
            }
            return result;
        }
        this.results[row][column] = result = Tracer.invoke((Invokable)spreadsheetCell, (Object)this, (Object[])this.params, (IRuntimeEnv)this.env, (Object)this);
        return result;
    }

    public void setValue(int row, int column, Object res) {
        this.results[row][column] = res;
    }

    private int height() {
        return this.spreadsheet.getHeight();
    }

    public void setFieldValue(String name, Object value) {
        this.targetModule.setFieldValue(name, value);
    }

    public String toString() {
        return "Spreadsheet[" + this.width() + " x " + this.height() + "]";
    }

    private int width() {
        return this.spreadsheet.getWidth();
    }

    public Object[][] getValues() {
        int height = this.height();
        int width = this.width();
        Object[][] resultArray = new Object[height][width];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                resultArray[row][col] = this.getValue(row, col);
            }
        }
        return resultArray;
    }

    public IRuntimeEnv getEnv() {
        return this.env;
    }
}

