/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetResultCalculator;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.method.RulesMethodInvoker;
import org.openl.types.IDynamicObject;
import org.openl.vm.IRuntimeEnv;

public class SpreadsheetInvoker
extends RulesMethodInvoker<Spreadsheet> {
    private static final Object[][] EMPTY_RESULT = new Object[0][0];
    protected final Object[][] preFetchedResult;

    public SpreadsheetInvoker(Spreadsheet spreadsheet) {
        super(spreadsheet);
        this.preFetchedResult = this.preFetchResult(spreadsheet);
    }

    @Override
    public boolean canInvoke() {
        return ((Spreadsheet)this.getInvokableMethod()).getResultBuilder() != null;
    }

    @Override
    public Object invokeSimple(Object target, Object[] params, IRuntimeEnv env) {
        SpreadsheetResultCalculator res = new SpreadsheetResultCalculator((Spreadsheet)this.getInvokableMethod(), (IDynamicObject)target, params, env, this.preFetchedResult);
        return ((Spreadsheet)this.getInvokableMethod()).getResultBuilder().buildResult(res);
    }

    protected Object[][] preFetchResult(Spreadsheet spreadsheet) {
        SpreadsheetCell[][] cc = spreadsheet.getCells();
        Object[][] res = cc.length == 0 ? EMPTY_RESULT : new Object[cc.length][cc[0].length];
        for (int i = 0; i < cc.length; ++i) {
            SpreadsheetCell[] row = cc[i];
            block6: for (int j = 0; j < row.length; ++j) {
                SpreadsheetCell cell = row[j];
                switch (cell.getSpreadsheetCellType()) {
                    case EMPTY: {
                        res[i][j] = cell.isDefaultPrimitiveCell() ? cell.getValue() : SpreadsheetResultCalculator.EMPTY_CELL;
                        continue block6;
                    }
                    case VALUE: 
                    case CONSTANT: {
                        res[i][j] = cell.getValue();
                        continue block6;
                    }
                    case METHOD: {
                        res[i][j] = SpreadsheetResultCalculator.METHOD_VALUE;
                    }
                }
            }
        }
        return res;
    }
}

