/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.sax;

import java.util.ArrayList;
import java.util.List;
import org.openl.excel.parser.sax.SAXSheetDescriptor;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class WorkbookHandler
extends DefaultHandler {
    private final List<SAXSheetDescriptor> sheetDescriptors = new ArrayList<SAXSheetDescriptor>();
    private boolean use1904Windowing = false;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String dateCompatibility;
        String date1904;
        if ("sheet".equals(localName)) {
            String name = attributes.getValue("name");
            String rIdQName = "r:id";
            if (attributes.getIndex(rIdQName) < 0) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!"id".equals(attributes.getLocalName(i))) continue;
                    rIdQName = attributes.getQName(i);
                    break;
                }
            }
            String referenceId = attributes.getValue(rIdQName);
            this.sheetDescriptors.add(new SAXSheetDescriptor(name, this.sheetDescriptors.size(), referenceId));
        } else if ("workbookPr".equals(localName) && (date1904 = attributes.getValue("date1904")) != null && this.isTrue(date1904) && ((dateCompatibility = attributes.getValue("dateCompatibility")) == null || this.isTrue(dateCompatibility))) {
            this.use1904Windowing = true;
        }
    }

    private boolean isTrue(String boolVariable) {
        return "1".equals(boolVariable) || "true".equals(boolVariable);
    }

    public List<SAXSheetDescriptor> getSheetDescriptors() {
        return this.sheetDescriptors;
    }

    public boolean isUse1904Windowing() {
        return this.use1904Windowing;
    }
}

