/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.Objects;
import org.openl.binding.MethodUtil;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.NodeUsage;
import org.openl.meta.IMetaInfo;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.lang.xls.types.DatatypeOpenConstructor;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.types.impl.MatchingOpenMethodDispatcher;
import org.openl.rules.types.impl.OverloadedMethodsDispatcherTable;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;

public class MethodUsage
implements NodeUsage {
    private final int startPos;
    private final int endPos;
    private final IOpenMethod method;

    public MethodUsage(int startPos, int endPos, IOpenMethod method) {
        this.startPos = startPos;
        this.endPos = endPos;
        this.method = method;
    }

    @Override
    public int getStart() {
        return this.startPos;
    }

    @Override
    public int getEnd() {
        return this.endPos;
    }

    public IOpenMethod getMethod() {
        return this.method;
    }

    private static String getTableUri(IOpenMethod method) {
        try {
            if (method instanceof ExecutableRulesMethod) {
                return ((ExecutableRulesMethod)method).getSyntaxNode().getUri();
            }
            if (method instanceof OverloadedMethodsDispatcherTable) {
                return ((OverloadedMethodsDispatcherTable)method).getDispatcherTable().getUri();
            }
            if (method instanceof MatchingOpenMethodDispatcher) {
                MatchingOpenMethodDispatcher matchingOpenMethodDispatcher = (MatchingOpenMethodDispatcher)method;
                if (matchingOpenMethodDispatcher.getCandidates().size() == 1) {
                    return MethodUsage.getTableUri(matchingOpenMethodDispatcher.getCandidates().get(0));
                }
                return matchingOpenMethodDispatcher.getDispatcherTable().getUri();
            }
            if (method instanceof DatatypeOpenConstructor && method.getDeclaringClass() instanceof DatatypeOpenClass) {
                IMetaInfo metaInfo = method.getDeclaringClass().getMetaInfo();
                return metaInfo == null ? null : metaInfo.getSourceUrl();
            }
            if (method.getInfo() != null) {
                return method.getInfo().getSourceUrl();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getUri() {
        return MethodUsage.getTableUri(this.method);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.RULE;
    }

    @Override
    public String getDescription() {
        StringBuilder buff = new StringBuilder();
        MethodUtil.printMethod((IOpenMethodHeader)this.method, (StringBuilder)buff);
        return buff.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodUsage that = (MethodUsage)o;
        return this.startPos == that.startPos && this.endPos == that.endPos && Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return Objects.hash(this.startPos, this.endPos, this.method);
    }
}

