/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.vm;

import java.util.ArrayDeque;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.RecursiveAction;
import org.openl.rules.context.RulesRuntimeContextFactory;
import org.openl.rules.vm.ArgumentCachingStorage;
import org.openl.rules.vm.CacheMode;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.SimpleVM;

public class SimpleRulesRuntimeEnv
extends SimpleVM.SimpleRuntimeEnv {
    private volatile boolean methodArgumentsCacheEnable = false;
    private volatile CacheMode cacheMode = CacheMode.READ_ONLY;
    private volatile boolean ignoreRecalculate = true;
    private volatile boolean originalCalculation = true;
    private ArgumentCachingStorage argumentCachingStorage;
    private IOpenClass topClass;
    private Queue<RecursiveAction> actionStack = null;

    public SimpleRulesRuntimeEnv() {
    }

    private SimpleRulesRuntimeEnv(SimpleRulesRuntimeEnv env) {
        super((SimpleVM.SimpleRuntimeEnv)env);
        this.argumentCachingStorage = env.getArgumentCachingStorage();
        this.methodArgumentsCacheEnable = env.methodArgumentsCacheEnable;
        this.cacheMode = env.cacheMode;
        this.ignoreRecalculate = env.ignoreRecalculate;
        this.originalCalculation = env.originalCalculation;
    }

    public IRuntimeEnv clone() {
        return new SimpleRulesRuntimeEnv(this);
    }

    public ArrayDeque<IRuntimeContext> cloneContextStack() {
        return new ArrayDeque<IRuntimeContext>(this.contextStack);
    }

    protected IRuntimeContext buildDefaultRuntimeContext() {
        return RulesRuntimeContextFactory.buildRulesRuntimeContext();
    }

    public boolean isMethodArgumentsCacheEnable() {
        return this.methodArgumentsCacheEnable;
    }

    public void changeMethodArgumentsCacheMode(CacheMode mode) {
        this.cacheMode = mode;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setMethodArgumentsCacheEnable(boolean enable) {
        this.methodArgumentsCacheEnable = enable;
    }

    public boolean isIgnoreRecalculation() {
        return this.ignoreRecalculate;
    }

    public void setIgnoreRecalculate(boolean ignoreRecalculate) {
        this.ignoreRecalculate = ignoreRecalculate;
    }

    public boolean isOriginalCalculation() {
        return this.originalCalculation;
    }

    public void setOriginalCalculation(boolean originalCalculation) {
        this.originalCalculation = originalCalculation;
    }

    public ArgumentCachingStorage getArgumentCachingStorage() {
        if (this.argumentCachingStorage == null) {
            this.argumentCachingStorage = new ArgumentCachingStorage(this);
        }
        return this.argumentCachingStorage;
    }

    public IOpenClass getTopClass() {
        return this.topClass;
    }

    public void setTopClass(IOpenClass topClass) {
        this.topClass = topClass;
    }

    public void pushAction(RecursiveAction action) {
        if (this.actionStack == null) {
            this.actionStack = new LinkedList<RecursiveAction>();
        }
        this.actionStack.add(action);
    }

    public boolean joinActionIfExists() {
        if (this.actionStack != null && !this.actionStack.isEmpty()) {
            RecursiveAction action = this.actionStack.poll();
            action.join();
            return true;
        }
        return false;
    }

    public boolean cancelActionIfExists() {
        if (this.actionStack != null && !this.actionStack.isEmpty()) {
            RecursiveAction action = this.actionStack.poll();
            action.cancel(true);
            return true;
        }
        return false;
    }
}

