/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.binding.MethodUtil;
import org.openl.binding.impl.BindingContextDelegator;
import org.openl.engine.OpenLSystemProperties;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableBoundNode;
import org.openl.rules.dt.DecisionTableLoader;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.IBaseDecisionRow;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.rules.lang.xls.XlsHelper;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.DecisionTableMetaInfoReader;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.table.properties.PropertiesLoader;
import org.openl.rules.table.properties.TableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.types.impl.MatchingOpenMethodDispatcher;
import org.openl.rules.validation.properties.dimentional.ArrayParameterColumn;
import org.openl.rules.validation.properties.dimentional.DecisionTableBuilder;
import org.openl.rules.validation.properties.dimentional.DispatcherTableReturnColumn;
import org.openl.rules.validation.properties.dimentional.DispatcherTableRules;
import org.openl.rules.validation.properties.dimentional.IDecisionTableColumn;
import org.openl.rules.validation.properties.dimentional.SimpleParameterColumn;
import org.openl.types.IMethodCaller;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.MethodDelegator;
import org.openl.types.impl.MethodKey;
import org.openl.types.impl.MethodSignature;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TableSyntaxNodeDispatcherBuilder {
    private final Logger log = LoggerFactory.getLogger(TableSyntaxNodeDispatcherBuilder.class);
    static final LinkedHashMap<String, IOpenClass> INCOME_PARAMS;
    static final String AUXILIARY_METHOD_DELIMETER = "$";
    private static final String ARGUMENT_PREFIX_IN_SIGNATURE = "arg_";
    private final RulesModuleBindingContext rulesModuleBindingContext;
    private final XlsModuleOpenClass moduleOpenClass;
    private final MatchingOpenMethodDispatcher dispatcher;

    TableSyntaxNodeDispatcherBuilder(RulesModuleBindingContext rulesModuleBindingContext, XlsModuleOpenClass moduleOpenClass, MatchingOpenMethodDispatcher dispatcher) {
        if (rulesModuleBindingContext == null || moduleOpenClass == null || dispatcher == null) {
            throw new IllegalArgumentException("None of the constructor parameters can be null");
        }
        this.rulesModuleBindingContext = rulesModuleBindingContext;
        this.moduleOpenClass = moduleOpenClass;
        this.dispatcher = dispatcher;
    }

    static String getDispatcherParameterNameForOriginalParameter(String parameterName) {
        return ARGUMENT_PREFIX_IN_SIGNATURE + parameterName;
    }

    private static IDecisionTableColumn makeColumn(TablePropertyDefinition dimensionProperty, DispatcherTableRules rules) {
        if (dimensionProperty.getType().isArray()) {
            return new ArrayParameterColumn(dimensionProperty, rules);
        }
        return new SimpleParameterColumn(dimensionProperty, rules);
    }

    private static boolean belongsToExcluded(String methodName) {
        boolean result = false;
        if ("getValue".equals(methodName)) {
            result = true;
        }
        return result;
    }

    TableSyntaxNode build() {
        TableSyntaxNode tsn = null;
        if (this.needToBuild()) {
            List<ITableProperties> propertiesFromMethods = this.getMethodsProperties();
            DispatcherTableRules rules = new DispatcherTableRules(propertiesFromMethods);
            List<IDecisionTableColumn> conditions = this.getConditions(propertiesFromMethods, rules);
            DispatcherTableReturnColumn returnColumn = new DispatcherTableReturnColumn(this.dispatcher.getType(), this.dispatcher.getName(), this.dispatcher.getSignature());
            DecisionTableBuilder decisionTableBuilder = new DecisionTableBuilder();
            decisionTableBuilder.setConditions(conditions);
            decisionTableBuilder.setReturnColumn(returnColumn);
            decisionTableBuilder.setTableName(this.getDispatcherTableName());
            decisionTableBuilder.setMethodName(this.getMethodName());
            decisionTableBuilder.setRulesNumber(rules.getRulesNumber());
            XlsSheetGridModel sheetWithTable = decisionTableBuilder.build();
            IGridTable decisionTableSource = sheetWithTable.getTables()[0];
            XlsSheetSourceCodeModule sheetSource = sheetWithTable.getSheetSource();
            try {
                tsn = XlsHelper.createTableSyntaxNode(decisionTableSource, sheetSource);
            }
            catch (OpenLCompilationException e) {
                this.rulesModuleBindingContext.addMessages(OpenLMessagesUtils.newErrorMessages((Throwable)e));
                return null;
            }
            IOpenClass originalReturnType = this.getMethodReturnType();
            Map<String, IOpenClass> updatedIncomeParams = this.updateIncomeParams();
            String tableName = this.getDispatcherTableName();
            IParameterDeclaration[] params = new IParameterDeclaration[updatedIncomeParams.size()];
            int i = 0;
            for (Map.Entry<String, IOpenClass> field : updatedIncomeParams.entrySet()) {
                params[i] = new ParameterDeclaration(field.getValue(), field.getKey());
                ++i;
            }
            MethodSignature signature = new MethodSignature(params);
            OpenMethodHeader header = new OpenMethodHeader(tableName, originalReturnType, (IMethodSignature)signature, (IOpenClass)this.moduleOpenClass);
            DecisionTableBoundNode boundNode = new DecisionTableBoundNode(tsn, this.moduleOpenClass.getOpenl(), (IOpenMethodHeader)header, this.moduleOpenClass);
            DecisionTable decisionTable = new DecisionTable((IOpenMethodHeader)header, boundNode);
            tsn.setMetaInfoReader(new DecisionTableMetaInfoReader((DecisionTableBoundNode)decisionTable.getBoundNode(), decisionTable));
            this.loadCreatedTable(decisionTable, tsn);
            this.dispatcher.setDecisionTableOpenMethod((IOpenMethod)decisionTable);
            IDecisionTableAlgorithm algorithm = decisionTable.getAlgorithm();
            if (algorithm != null) {
                algorithm.cleanParamValuesForIndexedConditions();
            }
            if (this.rulesModuleBindingContext.isExecutionMode()) {
                this.removeDebugInformation(decisionTable, tsn);
            }
        }
        return tsn;
    }

    private void removeDebugInformation(DecisionTable decisionTable, TableSyntaxNode tsn) {
        decisionTable.setBoundNode(null);
        this.clearCompositeMethods(decisionTable);
        if (!OpenLSystemProperties.isDTDispatchingMode(this.rulesModuleBindingContext.getExternalParams())) {
            tsn.setMember(null);
        }
    }

    private void clearCompositeMethods(DecisionTable decisionTable) {
        for (IBaseCondition iBaseCondition : decisionTable.getConditionRows()) {
            iBaseCondition.removeDebugInformation();
        }
        for (IBaseDecisionRow iBaseDecisionRow : decisionTable.getActionRows()) {
            iBaseDecisionRow.removeDebugInformation();
        }
    }

    private boolean needToBuild() {
        List<TablePropertyDefinition> dimensionalPropertiesDef = TablePropertyDefinitionUtils.getDimensionalTableProperties();
        List<ITableProperties> propertiesFromMethods = this.getMethodsProperties();
        for (TablePropertyDefinition dimensionProperty : dimensionalPropertiesDef) {
            if (!this.isSuitable(dimensionProperty.getName(), propertiesFromMethods)) continue;
            return true;
        }
        return false;
    }

    private List<IDecisionTableColumn> getConditions(List<ITableProperties> propertiesFromMethods, DispatcherTableRules rules) {
        List<TablePropertyDefinition> dimensionalPropertiesDef = TablePropertyDefinitionUtils.getDimensionalTableProperties();
        ArrayList<IDecisionTableColumn> conditions = new ArrayList<IDecisionTableColumn>();
        for (TablePropertyDefinition dimensionProperty : dimensionalPropertiesDef) {
            if (!this.isSuitable(dimensionProperty.getName(), propertiesFromMethods)) continue;
            conditions.add(TableSyntaxNodeDispatcherBuilder.makeColumn(dimensionProperty, rules));
        }
        return conditions;
    }

    private boolean isPropertyPresented(String propertyName, List<ITableProperties> methodsProperties) {
        for (ITableProperties properties : methodsProperties) {
            if (!StringUtils.isNotEmpty((CharSequence)properties.getPropertyValueAsString(propertyName))) continue;
            return true;
        }
        return false;
    }

    private IOpenMethod getMember() {
        return this.dispatcher.getCandidates().get(0);
    }

    private String getDispatcherTableName() {
        String originalTableName = this.getMethodName();
        return String.format("%s_%s", "validateGapOverlap", originalTableName);
    }

    private Map<String, IOpenClass> updateIncomeParams() {
        LinkedHashMap<String, IOpenClass> updatedIncomeParams = new LinkedHashMap<String, IOpenClass>();
        IMethodSignature originalSignature = this.getMethodSignature();
        for (int j = 0; j < originalSignature.getNumberOfParameters(); ++j) {
            updatedIncomeParams.put(TableSyntaxNodeDispatcherBuilder.getDispatcherParameterNameForOriginalParameter(originalSignature.getParameterName(j)), originalSignature.getParameterType(j));
        }
        updatedIncomeParams.putAll(INCOME_PARAMS);
        return updatedIncomeParams;
    }

    private List<ITableProperties> getMethodsProperties() {
        ArrayList<ITableProperties> propertiesValues = new ArrayList<ITableProperties>();
        for (IOpenMethod method : this.dispatcher.getCandidates()) {
            propertiesValues.add(PropertiesHelper.getTableProperties(method));
        }
        return propertiesValues;
    }

    private String getMethodName() {
        return this.getMember().getName();
    }

    private IOpenClass getMethodReturnType() {
        return this.getMember().getType();
    }

    private IMethodSignature getMethodSignature() {
        return this.dispatcher.getSignature();
    }

    private void loadCreatedTable(DecisionTable decisionTable, TableSyntaxNode tsn) {
        tsn.setMember((IOpenMember)decisionTable);
        PropertiesLoader propLoader = new PropertiesLoader(this.moduleOpenClass.getOpenl(), this.rulesModuleBindingContext, this.moduleOpenClass);
        propLoader.loadDefaultProperties(tsn);
        this.setTableProperties(tsn);
        DecisionTableLoader dtLoader = new DecisionTableLoader();
        try {
            dtLoader.loadAndBind(tsn, decisionTable, this.moduleOpenClass.getOpenl(), null, this.createContextWithAuxiliaryMethods());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.rulesModuleBindingContext.addMessages(OpenLMessagesUtils.newErrorMessages((Throwable)e));
        }
    }

    private IOpenMethod generateAuxiliaryMethod(IOpenMethod originalMethod, int index) {
        String auxiliaryMethodName = originalMethod.getName() + AUXILIARY_METHOD_DELIMETER + index;
        return new InternalMethodDelegator((IMethodCaller)originalMethod, auxiliaryMethodName);
    }

    private IBindingContext createContextWithAuxiliaryMethods() {
        List<IOpenMethod> candidates = this.dispatcher.getCandidates();
        HashMap<MethodKey, IOpenMethod> auxiliaryMethods = new HashMap<MethodKey, IOpenMethod>(candidates.size());
        for (int i = 0; i < candidates.size(); ++i) {
            IOpenMethod auxiliaryMethod = this.generateAuxiliaryMethod(candidates.get(i), i);
            auxiliaryMethods.put(new MethodKey(auxiliaryMethod), auxiliaryMethod);
        }
        return new InternalBindingContextDelegator(this.rulesModuleBindingContext, auxiliaryMethods);
    }

    private void setTableProperties(TableSyntaxNode tsn) {
        TableProperties properties = (TableProperties)tsn.getTableProperties();
        properties.setFieldValue("category", "Autogenerated - Dispatch by Properties");
        StringBuilder buf = new StringBuilder(250);
        buf.append(" Automatically created table to dispatch by dimensional properties values for method: ");
        MethodUtil.printMethod((IOpenMethodHeader)this.getMember(), (StringBuilder)buf);
        buf.append(". Please, edit original tables to make any change to the overloading logic.");
        properties.setFieldValue("description", buf.toString());
    }

    private boolean isSuitable(String dimensionPropertyName, List<ITableProperties> methodsProperties) {
        return this.isPropertyPresented(dimensionPropertyName, methodsProperties) && !"origin".equals(dimensionPropertyName);
    }

    static {
        Method[] methods;
        INCOME_PARAMS = new LinkedHashMap();
        for (Method method : methods = IRulesRuntimeContext.class.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") || TableSyntaxNodeDispatcherBuilder.belongsToExcluded(methodName)) continue;
            String fieldName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            INCOME_PARAMS.put(fieldName, (IOpenClass)JavaOpenClass.getOpenClass(method.getReturnType()));
        }
    }

    private static class InternalBindingContextDelegator
    extends BindingContextDelegator {
        private final Map<MethodKey, IOpenMethod> auxiliaryMethods;

        InternalBindingContextDelegator(RulesModuleBindingContext context, Map<MethodKey, IOpenMethod> auxiliaryMethods) {
            super((IBindingContext)context);
            this.auxiliaryMethods = auxiliaryMethods;
        }

        public IMethodCaller findMethodCaller(String namespace, String name, IOpenClass[] parTypes) {
            IOpenMethod auxiliaryMethod = this.auxiliaryMethods.get(new MethodKey(name, parTypes));
            if (auxiliaryMethod == null) {
                return super.findMethodCaller(namespace, name, parTypes);
            }
            return auxiliaryMethod;
        }
    }

    private static class InternalMethodDelegator
    extends MethodDelegator {
        final String auxiliaryMethodName;

        InternalMethodDelegator(IMethodCaller methodCaller, String auxiliaryMethodName) {
            super(methodCaller);
            this.auxiliaryMethodName = auxiliaryMethodName;
        }

        public String getName() {
            return this.auxiliaryMethodName;
        }
    }
}

