/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import org.openl.rules.table.GridRegion;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.validation.properties.dimentional.AConditionBuilder;
import org.openl.rules.validation.properties.dimentional.IDecisionTableColumn;

public class ArrayConditionBuilder
extends AConditionBuilder {
    ArrayConditionBuilder(IDecisionTableColumn condition, int conditionNumber) {
        super(condition, conditionNumber);
    }

    @Override
    protected void writeColumnType(IWritableGrid sheet, int columnStartIndex, int rowStartIndex) {
        sheet.setCellValue(columnStartIndex, rowStartIndex + 1, this.getCondition().getColumnType() + this.getConditionNumber());
        ArrayConditionBuilder.mergeArrayCells(sheet, 1, columnStartIndex, this.getCondition().getNumberOfLocalParameters());
    }

    @Override
    protected void writeCodeExpression(IWritableGrid sheet, int columnStartIndex, int rowStartIndex) {
        sheet.setCellValue(columnStartIndex, rowStartIndex + 2, this.getCondition().getCodeExpression());
        ArrayConditionBuilder.mergeArrayCells(sheet, 2, columnStartIndex, this.getCondition().getNumberOfLocalParameters());
    }

    @Override
    protected void writeParameterDeclaration(IWritableGrid sheet, int columnStartIndex, int rowStartIndex) {
        IDecisionTableColumn condition = this.getCondition();
        int numberOfLocalParameters = condition.getNumberOfLocalParameters();
        String parameterDeclaration = condition.getParameterDeclaration();
        for (int i = 1; i <= numberOfLocalParameters; ++i) {
            sheet.setCellValue(columnStartIndex, rowStartIndex + 3, parameterDeclaration + i);
            ++columnStartIndex;
        }
    }

    @Override
    protected void writeTitle(IWritableGrid sheet, int columnStartIndex, int rowStartIndex) {
        sheet.setCellValue(columnStartIndex, rowStartIndex + 4, this.getCondition().getTitle());
        ArrayConditionBuilder.mergeArrayCells(sheet, 4, columnStartIndex, this.getCondition().getNumberOfLocalParameters());
    }

    @Override
    protected void writeRuleValue(IWritableGrid sheet, int numberOfRules, int columnStartIndex, int rowStartIndex) {
        int startCol = columnStartIndex;
        for (int i = 0; i < numberOfRules; ++i) {
            for (int j = 0; j < this.getCondition().getNumberOfLocalParameters(); ++j) {
                sheet.setCellValue(columnStartIndex, i + rowStartIndex + 5, this.getCondition().getRuleValue(i, columnStartIndex - startCol));
                ++columnStartIndex;
            }
            columnStartIndex = startCol;
        }
    }

    private static void mergeArrayCells(IWritableGrid sheet, int rowIndex, int columnIndex, int numberOfValues) {
        int lastMergedColumnIndex = columnIndex + numberOfValues - 1;
        sheet.addMergedRegion(new GridRegion(rowIndex, columnIndex, rowIndex, lastMergedColumnIndex));
    }
}

