/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openl.binding.MethodUtil;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.rules.validation.ValidationUtils;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.validation.IOpenLValidator;
import org.openl.validation.ValidationResult;

public class UniqueMethodParameterNamesValidator
implements IOpenLValidator {
    private static final String MSG_FOR_TYPES = "Method '%s' conflicts with another method '%s', because of parameter types are treated by Java as identical.";
    private static final String MSG_FOR_NAMES = "Method '%s' conflicts with another method '%s', because of parameter names are different.";

    public ValidationResult validate(IOpenClass openClass) {
        LinkedHashSet<OpenLMessage> messages = new LinkedHashSet<OpenLMessage>();
        for (IOpenMethod method : openClass.getMethods()) {
            if (!(method instanceof OpenMethodDispatcher)) continue;
            OpenMethodDispatcher openMethodDispatcher = (OpenMethodDispatcher)method;
            List<IOpenMethod> candidates = openMethodDispatcher.getCandidates();
            int parameterCount = candidates.iterator().next().getSignature().getNumberOfParameters();
            HashSet[] parameterKeysByName = new HashSet[parameterCount];
            HashSet[] parameterKeysByType = new HashSet[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                parameterKeysByName[i] = new HashSet();
                parameterKeysByType[i] = new HashSet();
            }
            for (IOpenMethod candidate : candidates) {
                IMethodSignature signature = candidate.getSignature();
                for (int j = 0; j < parameterCount; ++j) {
                    if (signature.getParameterName(j) != null) {
                        parameterKeysByName[j].add(new ParameterNameKey(signature.getParameterName(j), candidate));
                    }
                    if (signature.getParameterType(j) == null) continue;
                    parameterKeysByType[j].add(new ParameterTypeKey(signature.getParameterType(j), candidate));
                }
            }
            for (MethodPairKey methodPair : this.buildMethodPairs(parameterKeysByName, parameterCount)) {
                this.addWarnForMethods(methodPair.methodA, methodPair.methodB, messages, MSG_FOR_NAMES);
            }
            for (MethodPairKey methodPair : this.buildMethodPairs(parameterKeysByType, parameterCount)) {
                this.addWarnForMethods(methodPair.methodA, methodPair.methodB, messages, MSG_FOR_TYPES);
            }
        }
        return ValidationUtils.withMessages(messages);
    }

    private Set<MethodPairKey> buildMethodPairs(Set<? extends ParameterKey>[] parameterKeys, int parameterCount) {
        HashSet<MethodPairKey> methodPairs = new HashSet<MethodPairKey>();
        for (int i = 0; i < parameterCount; ++i) {
            if (parameterKeys[i].size() <= 1) continue;
            List conflictMethods = parameterKeys[i].stream().map(ParameterKey::getMethod).collect(Collectors.toList());
            for (int j = 0; j < conflictMethods.size() - 1; ++j) {
                for (int k = j + 1; k < conflictMethods.size(); ++k) {
                    methodPairs.add(new MethodPairKey((IOpenMethod)conflictMethods.get(j), (IOpenMethod)conflictMethods.get(k)));
                }
            }
        }
        return methodPairs;
    }

    private void addWarnForMethods(IOpenMethod methodA, IOpenMethod methodB, Collection<OpenLMessage> messages, String message) {
        ISyntaxNode syntaxNodeA = ((IMemberMetaInfo)methodA).getSyntaxNode();
        ISyntaxNode syntaxNodeB = ((IMemberMetaInfo)methodB).getSyntaxNode();
        String signA = MethodUtil.printSignature((IOpenMethodHeader)methodA, (int)1);
        String signB = MethodUtil.printSignature((IOpenMethodHeader)methodB, (int)1);
        String messageA = String.format(message, signA, signB);
        String messageB = String.format(message, signB, signA);
        if (syntaxNodeA instanceof TableSyntaxNode) {
            messages.add(OpenLMessagesUtils.newWarnMessage((String)messageA, (ISyntaxNode)syntaxNodeA));
        }
        if (syntaxNodeB instanceof TableSyntaxNode) {
            messages.add(OpenLMessagesUtils.newWarnMessage((String)messageB, (ISyntaxNode)syntaxNodeB));
        }
    }

    private static class MethodPairKey {
        IOpenMethod methodA;
        IOpenMethod methodB;

        public MethodPairKey(IOpenMethod methodA, IOpenMethod methodB) {
            this.methodA = Objects.requireNonNull(methodA, "methodA cannot be null");
            this.methodB = Objects.requireNonNull(methodB, "methodB cannot be null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodPairKey that = (MethodPairKey)o;
            return Objects.equals(this.methodA, that.methodA) && Objects.equals(this.methodB, that.methodB);
        }

        public int hashCode() {
            return Objects.hash(this.methodA, this.methodB);
        }
    }

    private static class ParameterTypeKey
    implements ParameterKey {
        IOpenClass type;
        IOpenMethod method;

        public ParameterTypeKey(IOpenClass type, IOpenMethod method) {
            this.type = Objects.requireNonNull(type, "type cannot be null");
            this.method = Objects.requireNonNull(method, "method cannot be null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterTypeKey that = (ParameterTypeKey)o;
            return this.type.equals(that.type);
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }

        @Override
        public IOpenMethod getMethod() {
            return this.method;
        }
    }

    private static class ParameterNameKey
    implements ParameterKey {
        String name;
        IOpenMethod method;

        public ParameterNameKey(String name, IOpenMethod method) {
            this.name = Objects.requireNonNull(name, "name cannot be null");
            this.method = Objects.requireNonNull(method, "method cannot be null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterNameKey that = (ParameterNameKey)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        @Override
        public IOpenMethod getMethod() {
            return this.method;
        }
    }

    private static interface ParameterKey {
        public IOpenMethod getMethod();
    }
}

