/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openl.binding.MethodUtil;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.context.IRulesRuntimeContextOptimizationForOpenMethodDispatcher;
import org.openl.rules.lang.xls.binding.TableVersionComparator;
import org.openl.rules.lang.xls.binding.wrapper.IRulesMethodWrapper;
import org.openl.rules.lang.xls.binding.wrapper.WrapperLogic;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ITablePropertiesMethod;
import org.openl.rules.table.properties.DimensionPropertiesMethodKey;
import org.openl.rules.types.DuplicateMemberThrowExceptionHelper;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.MethodKey;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.Tracer;

public abstract class OpenMethodDispatcher
implements IOpenMethod {
    private IOpenMethod delegate;
    private MethodKey delegateKey;
    private final List<IOpenMethod> candidates = new ArrayList<IOpenMethod>();
    private final Map<Integer, DimensionPropertiesMethodKey> candidatesToDimensionKey = new HashMap<Integer, DimensionPropertiesMethodKey>();

    protected OpenMethodDispatcher() {
    }

    public OpenMethodDispatcher(IOpenMethod delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Method cannot be null");
        this.delegateKey = new MethodKey(delegate);
        this.candidates.add(delegate);
        if (delegate instanceof ITablePropertiesMethod) {
            int idx = this.candidates.size() - 1;
            this.candidatesToDimensionKey.put(idx, new DimensionPropertiesMethodKey(delegate));
        }
    }

    public IMethodSignature getSignature() {
        return this.delegate.getSignature();
    }

    public IOpenClass getDeclaringClass() {
        return this.delegate.getDeclaringClass();
    }

    public IMemberMetaInfo getInfo() {
        return null;
    }

    public IOpenClass getType() {
        return this.delegate.getType();
    }

    public boolean isStatic() {
        return this.delegate.isStatic();
    }

    public boolean isConstructor() {
        return false;
    }

    public String getDisplayName(int mode) {
        return this.delegate.getDisplayName(mode);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public IOpenMethod getMethod() {
        return this;
    }

    public List<IOpenMethod> getCandidates() {
        return Collections.unmodifiableList(this.candidates);
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        return Tracer.invoke(this::invokeInner, (Object)target, (Object[])params, (IRuntimeEnv)env, (Object)this);
    }

    public IOpenMethod findMatchingMethod(IRuntimeEnv env) {
        IOpenMethod method;
        IRuntimeContext context = env.getContext();
        if (context instanceof IRulesRuntimeContextOptimizationForOpenMethodDispatcher) {
            IRulesRuntimeContextOptimizationForOpenMethodDispatcher rulesRuntimeContextOptimizationForOpenMethodDispatcher = (IRulesRuntimeContextOptimizationForOpenMethodDispatcher)context;
            method = rulesRuntimeContextOptimizationForOpenMethodDispatcher.getMethodForOpenMethodDispatcher(this);
            if (method == null) {
                method = this.findMatchingMethod(this.candidates, context);
                rulesRuntimeContextOptimizationForOpenMethodDispatcher.putMethodForOpenMethodDispatcher(this, method);
            }
        } else {
            method = this.findMatchingMethod(this.candidates, context);
        }
        if (method == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Method signature: ");
            MethodUtil.printMethod((IOpenMethodHeader)this, (StringBuilder)sb);
            sb.append("\n");
            sb.append("Context: ");
            sb.append(context.toString());
            String message = String.format("Appropriate overloaded method for '%1$s' is not found. Details: \n%2$s", this.getName(), sb.toString());
            throw new OpenLRuntimeException(message);
        }
        if ((method = WrapperLogic.extractMethod(method)) instanceof IRulesMethodWrapper) {
            method = ((IRulesMethodWrapper)method).getDelegate();
        }
        return method;
    }

    private <R> R invokeInner(Object target, Object[] params, IRuntimeEnv env) {
        IOpenMethod method = this.findMatchingMethod(env);
        Tracer.put((Object)this, (String)"rule", (Object)method);
        return (R)method.invoke(target, params, env);
    }

    private IOpenMethod useActiveOrNewerVersion(IOpenMethod existedMethod, IOpenMethod newMethod) {
        int compareResult = TableVersionComparator.getInstance().compare(existedMethod, newMethod);
        if (compareResult > 0) {
            return newMethod;
        }
        if (compareResult == 0) {
            DuplicateMemberThrowExceptionHelper.throwDuplicateMethodExceptionIfMethodsAreNotTheSame(newMethod, existedMethod);
        }
        return existedMethod;
    }

    private int searchTheSameMethod(DimensionPropertiesMethodKey newMethodPropertiesKey) {
        for (Map.Entry<Integer, DimensionPropertiesMethodKey> it : this.candidatesToDimensionKey.entrySet()) {
            DimensionPropertiesMethodKey existedMethodPropertiesKey = it.getValue();
            if (existedMethodPropertiesKey.hashCode() != newMethodPropertiesKey.hashCode() || !newMethodPropertiesKey.equals(existedMethodPropertiesKey)) continue;
            return it.getKey();
        }
        return -1;
    }

    public void addMethod(IOpenMethod candidate) {
        MethodKey candidateKey = new MethodKey(candidate);
        if (this.delegateKey.equals((Object)candidateKey)) {
            int i = -1;
            DimensionPropertiesMethodKey dimensionMethodKey = null;
            if (candidate instanceof ITablePropertiesMethod) {
                dimensionMethodKey = new DimensionPropertiesMethodKey(candidate);
                i = this.searchTheSameMethod(dimensionMethodKey);
            }
            if (i < 0) {
                this.candidates.add(candidate);
                if (dimensionMethodKey != null) {
                    int idx = this.candidates.size() - 1;
                    this.candidatesToDimensionKey.put(idx, dimensionMethodKey);
                }
            } else {
                IOpenMethod existedMethod = this.candidates.get(i);
                candidate = this.useActiveOrNewerVersion(existedMethod, candidate);
                this.candidates.set(i, candidate);
                this.candidatesToDimensionKey.put(i, new DimensionPropertiesMethodKey(candidate));
            }
        } else {
            throw new IllegalStateException(String.format("Unexpected signature '%s' is found.", MethodUtil.printSignature((IOpenMethodHeader)this, (int)1)));
        }
    }

    protected abstract IOpenMethod findMatchingMethod(List<IOpenMethod> var1, IRuntimeContext var2);

    public IOpenMethod getTargetMethod() {
        return this.delegate;
    }

    public abstract TableSyntaxNode getDispatcherTable();
}

