/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.result;

import java.util.Collection;
import java.util.Iterator;
import org.openl.rules.testmethod.result.GenericComparator;
import org.openl.rules.testmethod.result.TestResultComparator;
import org.openl.rules.testmethod.result.TestResultComparatorFactory;

class CollectionComparator
extends GenericComparator<Collection<?>> {
    private static final CollectionComparator INSTANCE = new CollectionComparator();
    private final TestResultComparator comparator = TestResultComparatorFactory.getComparator(Object.class, null);

    private CollectionComparator() {
    }

    @Override
    boolean fit(Object expected, Object actual) {
        return !(expected != null && !(expected instanceof Collection) || actual != null && !(actual instanceof Collection));
    }

    @Override
    boolean isEmpty(Collection<?> object) {
        return object.isEmpty();
    }

    @Override
    boolean equals(Collection<?> expected, Collection<?> actual) {
        int size = expected.size();
        if (size != actual.size()) {
            return false;
        }
        Iterator<?> expectedItr = expected.iterator();
        Iterator<?> actualItr = actual.iterator();
        while (expectedItr.hasNext() && actualItr.hasNext()) {
            Object actualVal;
            Object expectedVal = expectedItr.next();
            if (this.comparator.isEqual(expectedVal, actualVal = actualItr.next())) continue;
            return false;
        }
        return !expectedItr.hasNext() && !actualItr.hasNext();
    }

    public static TestResultComparator getInstance() {
        return INSTANCE;
    }
}

