/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.export;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.openl.binding.impl.CastToWiderType;
import org.openl.rules.data.PrimaryKeyField;
import org.openl.rules.lang.xls.TableSyntaxNodeUtils;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestSuite;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.testmethod.export.BaseExport;
import org.openl.rules.testmethod.export.Cursor;
import org.openl.rules.testmethod.export.ExportUtils;
import org.openl.rules.testmethod.export.FieldDescriptor;
import org.openl.rules.testmethod.export.Styles;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.util.ClassUtils;

class ParameterExport
extends BaseExport {
    ParameterExport(Styles styles) {
        this.styles = styles;
    }

    public void write(SXSSFSheet sheet, List<TestUnitsResults> tests) {
        if (tests.isEmpty()) {
            return;
        }
        int rowNum = 2;
        int colNum = 1;
        for (TestUnitsResults test : tests) {
            if (test.getTestSuite().getNumberOfTests() == 0) continue;
            SXSSFRow row = sheet.createRow(rowNum);
            String testName = this.getTestName(test);
            this.createCell((Row)row, colNum, "Parameters of " + testName, this.styles.parametersInfo);
            List<List<FieldDescriptor>> nonEmptyFields = this.getAllNonEmptyFields(test.getTestSuite().getTests());
            Cursor start = new Cursor(rowNum += 2, colNum);
            Cursor lowestRight = this.writeHeaderForFields(sheet, start, test, nonEmptyFields);
            rowNum = lowestRight.getRowNum() + 1;
            rowNum = this.writeValuesForFields((Sheet)sheet, new Cursor(rowNum, colNum), test, nonEmptyFields);
            rowNum += 3;
        }
    }

    private String getTestName(TestUnitsResults test) {
        TestSuite testSuite = test.getTestSuite();
        TestSuiteMethod testSuiteMethod = testSuite.getTestSuiteMethod();
        if (testSuiteMethod != null) {
            return TableSyntaxNodeUtils.getTestName((IOpenMethod)testSuiteMethod);
        }
        if (testSuite.getNumberOfTests() > 0) {
            return testSuite.getTest(0).getTestedMethod().getName();
        }
        return "Unknown";
    }

    private Cursor writeHeaderForFields(SXSSFSheet sheet, Cursor start, TestUnitsResults test, List<List<FieldDescriptor>> nonEmptyFields) {
        TreeSet<WriteTask> tasks = new TreeSet<WriteTask>();
        int rowNum = start.getRowNum();
        int colNum = start.getColNum();
        tasks.add(new WriteTask(new Cursor(rowNum, colNum++), (Object)"ID", this.styles.header));
        TestSuite testSuite = test.getTestSuite();
        ParameterWithValueDeclaration[] params = testSuite.getTest(0).getExecutionParams();
        for (int i = 0; i < params.length; ++i) {
            ParameterWithValueDeclaration param = params[i];
            boolean hasPK = this.isHasPK(param);
            List<FieldDescriptor> fields = nonEmptyFields.get(i);
            if (ClassUtils.isAssignable((Class)param.getType().getInstanceClass(), Map.class)) {
                Map map = (Map)param.getValue();
                for (Object key : map.keySet()) {
                    tasks.add(new WriteTask(new Cursor(rowNum, colNum++), (Object)(param.getName() + "[\"" + key + "\"]:" + map.get(key).getClass().getSimpleName()), this.styles.header));
                }
                continue;
            }
            if (fields == null || fields.isEmpty()) {
                tasks.add(new WriteTask(new Cursor(rowNum, colNum++), (Object)param.getName(), this.styles.header));
                continue;
            }
            String prefix = param.getName() + ".";
            if (hasPK) {
                tasks.add(new WriteTask(new Cursor(rowNum, colNum++), (Object)(prefix + "_PK_"), this.styles.header));
            }
            colNum = this.addHeaderTasks(tasks, new Cursor(rowNum, colNum), fields, prefix, param);
        }
        return this.performWrite((Sheet)sheet, start, tasks, this.getLastColumn(test, nonEmptyFields));
    }

    private boolean isHasPK(ParameterWithValueDeclaration param) {
        return param.getKeyField() instanceof PrimaryKeyField;
    }

    private int addHeaderTasks(TreeSet<WriteTask> tasks, Cursor cursor, List<FieldDescriptor> fields, String prefix, ParameterWithValueDeclaration param) {
        int colNum = cursor.getColNum();
        int rowNum = cursor.getRowNum();
        for (FieldDescriptor fieldDescriptor : fields) {
            String fieldName = fieldDescriptor.getField().getName();
            int width = fieldDescriptor.getLeafNodeCount();
            if (fieldDescriptor.getChildren() == null) {
                if (ClassUtils.isAssignable((Class)fieldDescriptor.getField().getType().getInstanceClass(), Map.class)) {
                    Map map = (Map)ExportUtils.fieldValue(param.getValue(), fieldDescriptor.getField());
                    for (Object key : map.keySet()) {
                        tasks.add(new WriteTask(new Cursor(rowNum, colNum++), (Object)(prefix + fieldName + "[\"" + key + "\"]:" + map.get(key).getClass().getSimpleName()), this.styles.header));
                    }
                    continue;
                }
                tasks.add(new WriteTask(new Cursor(rowNum, colNum), (Object)(prefix + fieldName), this.styles.header));
            } else {
                this.addHeaderTasks(tasks, new Cursor(rowNum, colNum), fieldDescriptor.getChildren(), prefix + fieldName + ".", param);
            }
            colNum += width;
        }
        return colNum;
    }

    private int writeValuesForFields(Sheet sheet, Cursor start, TestUnitsResults test, List<List<FieldDescriptor>> nonEmptyFields) {
        TestDescription[] descriptions;
        int rowNum = start.getRowNum();
        int colNum = 1;
        int lastColNum = this.getLastColumn(test, nonEmptyFields);
        for (TestDescription description : descriptions = test.getTestSuite().getTests()) {
            TreeSet<WriteTask> tasks = new TreeSet<WriteTask>();
            int maxHeight = this.getMaxHeight(description, nonEmptyFields);
            tasks.add(new WriteTask(new Cursor(rowNum, colNum++), description.getId(), this.styles.parameterValue, maxHeight));
            ParameterWithValueDeclaration[] executionParams = description.getExecutionParams();
            for (int p = 0; p < executionParams.length; ++p) {
                ParameterWithValueDeclaration parameter = executionParams[p];
                Object[] value = parameter.getValue();
                if (value instanceof Collection) {
                    value = ((Collection)value).toArray();
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    for (Object val : map.values()) {
                        tasks.add(new WriteTask(new Cursor(rowNum, colNum++), (Object)val.toString(), this.styles.header));
                    }
                    continue;
                }
                List<FieldDescriptor> fields = nonEmptyFields.get(p);
                if (fields == null) {
                    tasks.add(new WriteTask(new Cursor(rowNum, colNum++), value, this.styles.parameterValue, maxHeight));
                    continue;
                }
                if (this.isHasPK(parameter)) {
                    IOpenField keyField = parameter.getKeyField();
                    Object id = ExportUtils.fieldValue(parameter.getValue(), keyField);
                    if (id != null && id.getClass().isArray()) {
                        int pkRow = rowNum;
                        int count = Array.getLength(id);
                        for (int i = 0; i < count; ++i) {
                            int height = this.getRowHeight(Array.get(value, i), fields);
                            tasks.add(new WriteTask(new Cursor(pkRow, colNum), Array.get(id, i), this.styles.parameterValue, height));
                            pkRow += height;
                        }
                    } else {
                        tasks.add(new WriteTask(new Cursor(rowNum, colNum), id, this.styles.parameterValue, maxHeight));
                    }
                    ++colNum;
                }
                this.addValueTasks(tasks, new Cursor(rowNum, colNum), fields, value, maxHeight);
                colNum += this.getFieldWidth(fields);
            }
            Cursor cursor = this.performWrite(sheet, new Cursor(rowNum, 1), tasks, lastColNum);
            rowNum = cursor.getRowNum() + 1;
            colNum = 1;
        }
        return rowNum;
    }

    private void addValueTasks(TreeSet<WriteTask> tasks, Cursor cursor, List<FieldDescriptor> fields, Object value, int rowHeight) {
        int colNum = cursor.getColNum();
        int rowNum = cursor.getRowNum();
        if (value != null && value.getClass().isArray()) {
            int count = Array.getLength(value);
            int heightLeft = rowHeight;
            for (int i = 0; i < count; ++i) {
                Object elem = Array.get(value, i);
                int height = this.getRowHeight(elem, fields);
                if (i < count - 1) {
                    this.addValueTasks(tasks, new Cursor(rowNum, colNum), fields, elem, height);
                    heightLeft -= height;
                } else {
                    this.addValueTasks(tasks, new Cursor(rowNum, colNum), fields, elem, heightLeft);
                }
                rowNum += height;
            }
        } else {
            for (FieldDescriptor fieldDescriptor : fields) {
                Object[] fieldValue = ExportUtils.fieldValue(value, fieldDescriptor.getField());
                List<FieldDescriptor> children = fieldDescriptor.getChildren();
                if (fieldValue instanceof Map) {
                    Map map = (Map)fieldValue;
                    for (Object val : map.values()) {
                        tasks.add(new WriteTask(new Cursor(rowNum, colNum++), (Object)val.toString(), this.styles.header));
                    }
                    continue;
                }
                if (fieldValue instanceof Collection) {
                    fieldValue = ((Collection)fieldValue).toArray();
                }
                if (children == null) {
                    tasks.add(new WriteTask(new Cursor(rowNum, colNum), fieldValue, this.styles.parameterValue, rowHeight));
                } else {
                    this.addValueTasks(tasks, new Cursor(rowNum, colNum), children, fieldValue, rowHeight);
                }
                colNum += fieldDescriptor.getLeafNodeCount();
            }
        }
    }

    private int getRowHeight(Object value, List<FieldDescriptor> fields) {
        if (value == null || fields == null) {
            return 1;
        }
        if (value instanceof Collection) {
            value = ((Collection)value).toArray();
        }
        if (value.getClass().isArray()) {
            int count = Array.getLength(value);
            int height = 0;
            for (int i = 0; i < count; ++i) {
                height += this.getRowHeight(Array.get(value, i), fields);
            }
            return height == 0 ? 1 : height;
        }
        int maxSize = 1;
        for (FieldDescriptor fieldDescriptor : fields) {
            int size = fieldDescriptor.getMaxArraySize(value);
            if (size <= maxSize) continue;
            maxSize = size;
        }
        return maxSize;
    }

    private int getFieldWidth(List<FieldDescriptor> fields) {
        int colNum = 0;
        for (FieldDescriptor fieldDescriptor : fields) {
            colNum += fieldDescriptor.getLeafNodeCount();
        }
        return colNum == 0 ? 1 : colNum;
    }

    private int getMaxHeight(TestDescription description, List<List<FieldDescriptor>> nonEmptyFields) {
        int maxHeight = 1;
        ParameterWithValueDeclaration[] executionParams = description.getExecutionParams();
        for (int i = 0; i < executionParams.length; ++i) {
            ParameterWithValueDeclaration param = executionParams[i];
            List<FieldDescriptor> fields = nonEmptyFields.get(i);
            int rowHeight = this.getRowHeight(param.getValue(), fields);
            if (rowHeight <= maxHeight) continue;
            maxHeight = rowHeight;
        }
        return maxHeight;
    }

    private List<List<FieldDescriptor>> getAllNonEmptyFields(TestDescription[] descriptions) {
        TestDescription description = descriptions[0];
        ParameterWithValueDeclaration[] executionParams = description.getExecutionParams();
        ArrayList<List<FieldDescriptor>> result = new ArrayList<List<FieldDescriptor>>(executionParams.length);
        for (int i = 0; i < executionParams.length; ++i) {
            ParameterWithValueDeclaration param = executionParams[i];
            List<Object> values = this.valuesForAllCases(descriptions, i);
            if (ClassUtils.isAssignable((Class)param.getType().getInstanceClass(), Collection.class)) {
                IOpenClass paramType = CastToWiderType.defineCollectionWiderType((Collection)((Collection)param.getValue()));
                result.add(FieldDescriptor.nonEmptyFields(paramType, values));
                continue;
            }
            result.add(FieldDescriptor.nonEmptyFields(param.getType(), values));
        }
        return result;
    }

    private Cursor performWrite(Sheet sheet, Cursor start, TreeSet<WriteTask> tasks, int lastCellNum) {
        int lowestRowNum = start.getRowNum();
        int rightColNum = start.getColNum();
        Row row = sheet.createRow(lowestRowNum);
        for (WriteTask task : tasks) {
            Cursor cursor = task.getCursor();
            int rowNum = cursor.getRowNum();
            int colNum = cursor.getColNum();
            if (rowNum > lowestRowNum) {
                this.styleEmptyCells(row, start.getColNum(), lastCellNum);
                row = sheet.createRow(rowNum);
                lowestRowNum = rowNum;
            }
            if (colNum > rightColNum) {
                rightColNum = colNum;
            }
            this.createCell(row, colNum, task.getValue(), task.getStyle());
            int height = task.getHeight();
            if (height <= 1) continue;
            int lastRow = rowNum + height - 1;
            CellRangeAddress region = new CellRangeAddress(rowNum, lastRow, colNum, colNum);
            row.getSheet().addMergedRegionUnsafe(region);
        }
        this.styleEmptyCells(row, start.getColNum(), lastCellNum);
        return new Cursor(lowestRowNum, rightColNum);
    }

    private void styleEmptyCells(Row row, int firstCellNum, int lastCellNum) {
        for (int i = firstCellNum; i <= lastCellNum; ++i) {
            Cell cell = row.getCell(i);
            if (cell != null) continue;
            this.createCell(row, i, null, this.styles.parameterAbsent);
        }
    }

    private int getLastColumn(TestUnitsResults test, List<List<FieldDescriptor>> nonEmptyFields) {
        int lastColumn = 1;
        TestSuite testSuite = test.getTestSuite();
        ParameterWithValueDeclaration[] params = testSuite.getTest(0).getExecutionParams();
        for (int i = 0; i < params.length; ++i) {
            List<FieldDescriptor> fields;
            ParameterWithValueDeclaration param = params[i];
            if (this.isHasPK(param)) {
                ++lastColumn;
            }
            if ((fields = nonEmptyFields.get(i)) == null) {
                ++lastColumn;
                continue;
            }
            for (FieldDescriptor field : fields) {
                lastColumn += field.getLeafNodeCount();
            }
        }
        return lastColumn;
    }

    private List<Object> valuesForAllCases(TestDescription[] testDescriptions, int paramNum) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (TestDescription description : testDescriptions) {
            ParameterWithValueDeclaration[] executionParams = description.getExecutionParams();
            if (executionParams.length > 0) {
                values.add(executionParams[paramNum].getValue());
                continue;
            }
            values.add(null);
        }
        return values;
    }

    private static final class WriteTask
    implements Comparable<WriteTask> {
        private final Cursor cursor;
        private final Object value;
        private final CellStyle style;
        private final int height;

        private WriteTask(Cursor cursor, Object value, CellStyle style) {
            this(cursor, value, style, 1);
        }

        private WriteTask(Cursor cursor, Object value, CellStyle style, int height) {
            this.cursor = cursor;
            this.value = value;
            this.style = style;
            this.height = height;
        }

        public Cursor getCursor() {
            return this.cursor;
        }

        public Object getValue() {
            return this.value;
        }

        public CellStyle getStyle() {
            return this.style;
        }

        public int getHeight() {
            return this.height;
        }

        @Override
        public int compareTo(WriteTask o) {
            Cursor cursor1 = this.getCursor();
            Cursor cursor2 = o.getCursor();
            int rowComparison = cursor1.getRowNum() - cursor2.getRowNum();
            return rowComparison != 0 ? rowComparison : cursor1.getColNum() - cursor2.getColNum();
        }
    }
}

