/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import java.util.List;
import org.openl.base.INamedThing;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.testmethod.ITestUnit;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestStatus;
import org.openl.rules.testmethod.TestSuite;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.types.IMethodSignature;
import org.openl.util.ClassUtils;

public class TestUnitsResults
implements INamedThing {
    private final TestSuite testSuite;
    private final ArrayList<ITestUnit> testUnits = new ArrayList();
    private boolean testedRulesHaveErrors = false;

    public TestUnitsResults(TestSuite testSuite) {
        this.testSuite = testSuite;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public String getName() {
        return this.testSuite.getDisplayName(0);
    }

    public String getDisplayName(int mode) {
        return this.testSuite.getDisplayName(mode);
    }

    public List<ITestUnit> getTestUnits() {
        return this.testUnits;
    }

    public List<ITestUnit> getFilteredTestUnits(boolean failuresOnly, int size) {
        if (this.testUnits != null && failuresOnly) {
            ArrayList<ITestUnit> failedUnits = new ArrayList<ITestUnit>();
            for (ITestUnit testUnit : this.testUnits) {
                if (testUnit.getResultStatus() == TestStatus.TR_OK || failedUnits.size() >= size && size != -1) continue;
                failedUnits.add(testUnit);
            }
            return failedUnits;
        }
        return this.testUnits;
    }

    public long getExecutionTime() {
        long executionTime = 0L;
        if (this.testUnits != null) {
            for (ITestUnit testUnit : this.testUnits) {
                executionTime += testUnit.getExecutionTime();
            }
        }
        return executionTime;
    }

    void addTestUnit(ITestUnit testUnit) {
        this.testUnits.add(testUnit);
    }

    public int getNumberOfFailures() {
        if (this.testedRulesHaveErrors) {
            return this.getTestSuite().getTests().length;
        }
        int cnt = 0;
        for (int i = 0; i < this.getNumberOfTestUnits(); ++i) {
            if (this.testUnits.get(i).getResultStatus() == TestStatus.TR_OK) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getNumberOfErrors() {
        int cnt = 0;
        for (int i = 0; i < this.getNumberOfTestUnits(); ++i) {
            if (this.testUnits.get(i).getResultStatus() != TestStatus.TR_EXCEPTION) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getNumberOfAssertionFailures() {
        int cnt = 0;
        for (int i = 0; i < this.getNumberOfTestUnits(); ++i) {
            if (this.testUnits.get(i).getResultStatus() != TestStatus.TR_NEQ) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getNumberOfTestUnits() {
        return this.testUnits.size();
    }

    public boolean hasDescription() {
        for (ITestUnit testUnit : this.testUnits) {
            if (testUnit.getTest().getDescription() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasContext() {
        for (ITestUnit testUnit : this.testUnits) {
            if (!testUnit.getTest().isRuntimeContextDefined()) continue;
            return true;
        }
        return false;
    }

    public boolean hasExpected() {
        for (ITestUnit testUnit : this.testUnits) {
            TestDescription test = testUnit.getTest();
            if (!test.isExpectedResultDefined() && !test.isExpectedErrorDefined()) continue;
            return true;
        }
        return false;
    }

    public boolean isSpreadsheetResultTester() {
        return ClassUtils.isAssignable((Class)this.testSuite.getTestedMethod().getType().getInstanceClass(), SpreadsheetResult.class);
    }

    public boolean isRunmethod() {
        return this.testSuite.getTestSuiteMethod().isRunMethod();
    }

    public String[] getTestDataColumnDisplayNames() {
        String[] columnTechnicalNames = this.getTestDataColumnHeaders();
        String[] columnDisplayNames = new String[columnTechnicalNames.length];
        for (int i = 0; i < columnDisplayNames.length; ++i) {
            TestSuiteMethod testSuiteMethod = this.testSuite.getTestSuiteMethod();
            String displayName = testSuiteMethod == null ? null : testSuiteMethod.getColumnDisplayName(columnTechnicalNames[i]);
            columnDisplayNames[i] = displayName != null ? displayName : columnTechnicalNames[i];
        }
        return columnDisplayNames;
    }

    private String[] getColumnDisplayNames(String type) {
        ArrayList<String> displayNames = new ArrayList<String>();
        TestSuiteMethod test = this.testSuite.getTestSuiteMethod();
        if (test != null) {
            for (int i = 0; i < test.getColumnsCount(); ++i) {
                String columnName = test.getColumnName(i);
                if (columnName == null || !columnName.startsWith(type)) continue;
                displayNames.add(test.getColumnDisplayName(columnName));
            }
        }
        return displayNames.toArray(new String[0]);
    }

    public String[] getContextColumnDisplayNames() {
        return this.getColumnDisplayNames("_context_");
    }

    public String[] getTestResultColumnDisplayNames() {
        return this.getColumnDisplayNames("_res_");
    }

    public String[] getTestDataColumnHeaders() {
        IMethodSignature testMethodSignature = this.testSuite.getTestedMethod().getSignature();
        int len = testMethodSignature.getParameterTypes().length;
        String[] res = new String[len];
        for (int i = 0; i < len; ++i) {
            res[i] = testMethodSignature.getParameterName(i);
        }
        return res;
    }

    public boolean isTestedRulesHaveErrors() {
        return this.testedRulesHaveErrors;
    }

    public void setTestedRulesHaveErrors(boolean testedRulesHaveErrors) {
        this.testedRulesHaveErrors = testedRulesHaveErrors;
    }
}

