/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.DataNodeBinder;
import org.openl.rules.data.DataTableBindHelper;
import org.openl.rules.data.ITable;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.DataTableMetaInfoReader;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.testmethod.TestMethodBoundNode;
import org.openl.rules.testmethod.TestMethodOpenClass;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.MessageUtils;
import org.openl.util.TableNameChecker;

public class TestMethodNodeBinder
extends DataNodeBinder {
    private static final int TESTED_METHOD_INDEX = 1;
    private static final int TABLE_NAME_INDEX = 2;
    private static final AtomicInteger counter = new AtomicInteger();

    @Override
    protected ATableBoundNode makeNode(TableSyntaxNode tableSyntaxNode, XlsModuleOpenClass module, RulesModuleBindingContext bindingContext) {
        TestMethodBoundNode boundNode = new TestMethodBoundNode(tableSyntaxNode, module);
        if (!bindingContext.isExecutionMode()) {
            tableSyntaxNode.setMetaInfoReader(new DataTableMetaInfoReader(boundNode));
        }
        return boundNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMemberBoundNode preBind(TableSyntaxNode tableSyntaxNode, OpenL openl, RulesModuleBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        String tableName;
        if (bindingContext.isExecutionMode()) {
            return null;
        }
        ILogicalTable table = tableSyntaxNode.getTable();
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table.getSource(), (IBindingContext)bindingContext);
        IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)" \n\r");
        if (parsedHeader.length < 2) {
            throw SyntaxNodeExceptionUtils.createError((String)"Test table format: Test <methodname> <testname>", (IOpenSourceCodeModule)source);
        }
        String methodName = parsedHeader[1].getIdentifier();
        if (parsedHeader.length == 2) {
            this.validateTableName(methodName, (ISyntaxNode)parsedHeader[1], (IBindingContext)bindingContext);
            tableName = methodName + "$" + parsedHeader[0].getIdentifier() + "$" + counter.getAndIncrement();
        } else {
            tableName = parsedHeader[2].getIdentifier();
            this.validateTableName(tableName, (ISyntaxNode)parsedHeader[2], (IBindingContext)bindingContext);
        }
        OpenMethodHeader header = new OpenMethodHeader(tableName, (IOpenClass)JavaOpenClass.getOpenClass(TestUnitsResults.class), IMethodSignature.VOID, (IOpenClass)module);
        TestedMethodBindingDetails best = null;
        boolean hasNoErrorBinding = false;
        ArrayList<TestedMethodBindingDetails> noErrorsCases = null;
        for (IOpenMethod testedMethod : module.getMethods()) {
            if (!methodName.equals(testedMethod.getName())) continue;
            TestedMethodBindingDetails current = new TestedMethodBindingDetails();
            current.testedMethod = testedMethod;
            current.testMethodBoundNode = (TestMethodBoundNode)this.makeNode(tableSyntaxNode, module, bindingContext);
            TestSuiteMethod testSuite = new TestSuiteMethod(testedMethod, (IOpenMethodHeader)header, current.testMethodBoundNode);
            current.testMethodBoundNode.setTestSuite(testSuite);
            current.testMethodOpenClass = new TestMethodOpenClass(tableName, testedMethod);
            if (current.testMethodOpenClass.getInstanceClass() == null) {
                String message = String.format("Table '%s' is defined with errors.", methodName);
                throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)parsedHeader[1]);
            }
            bindingContext.pushErrors();
            bindingContext.pushMessages();
            try {
                current.dataTable = this.makeTable(module, tableSyntaxNode, tableName, (IOpenClass)current.testMethodOpenClass, (IBindingContext)bindingContext, openl, false);
            }
            finally {
                current.errors = bindingContext.popErrors();
                if (current.errors == null) {
                    current.errors = Collections.emptyList();
                }
                current.messages = bindingContext.popMessages();
                if (current.messages == null) {
                    current.messages = Collections.emptyList();
                }
            }
            current.testMethodBoundNode.setTable(current.dataTable);
            if (!(current.errors.isEmpty() || best != null && best.errors.size() <= current.errors.size())) {
                best = current;
                continue;
            }
            if (!current.errors.isEmpty()) continue;
            if (!hasNoErrorBinding) {
                hasNoErrorBinding = true;
                best = current;
                continue;
            }
            if (noErrorsCases == null) {
                noErrorsCases = new ArrayList<TestedMethodBindingDetails>();
                noErrorsCases.add(best);
            }
            noErrorsCases.add(current);
        }
        if (noErrorsCases != null && noErrorsCases.size() > 1) {
            ArrayList<TestedMethodBindingDetails> exactMatches = new ArrayList<TestedMethodBindingDetails>();
            for (TestedMethodBindingDetails noErrorCase : noErrorsCases) {
                int c = 0;
                block5: for (int i = 0; i < noErrorCase.testedMethod.getSignature().getNumberOfParameters(); ++i) {
                    String parameterName = noErrorCase.testedMethod.getSignature().getParameterName(i);
                    for (int j = 0; j < noErrorCase.dataTable.getNumberOfColumns(); ++j) {
                        String columnFieldName = noErrorCase.dataTable.getColumnDescriptor(j).getName();
                        if (!Objects.equals(columnFieldName, parameterName)) continue;
                        ++c;
                        continue block5;
                    }
                }
                if (c != noErrorCase.testedMethod.getSignature().getNumberOfParameters()) continue;
                exactMatches.add(noErrorCase);
            }
            if (exactMatches.isEmpty()) {
                throw new AmbiguousMethodException(methodName, noErrorsCases.stream().map(e -> e.testedMethod).collect(Collectors.toList()));
            }
            if (exactMatches.size() > 1) {
                throw new AmbiguousMethodException(methodName, exactMatches.stream().map(e -> e.testedMethod).collect(Collectors.toList()));
            }
            best = (TestedMethodBindingDetails)exactMatches.iterator().next();
        }
        if (best != null) {
            best.testMethodBoundNode.setTable(best.dataTable);
            DataNodeBinder.putSubTableForBusinessView(tableSyntaxNode, (IOpenClass)best.testMethodOpenClass);
            best.messages.forEach(arg_0 -> ((RulesModuleBindingContext)bindingContext).addMessage(arg_0));
            best.errors.forEach(arg_0 -> ((RulesModuleBindingContext)bindingContext).addError(arg_0));
            return best.testMethodBoundNode;
        }
        String message = MessageUtils.getTableNotFoundErrorMessage((String)methodName);
        throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)parsedHeader[1]);
    }

    private void validateTableName(String tableName, ISyntaxNode syntaxNode, IBindingContext context) {
        if (TableNameChecker.isInvalidJavaIdentifier((String)tableName)) {
            String message = String.format("%s '%s' name error. Name can only have letters, digits, _, $ and should not start with a digit.", "Test table", tableName);
            context.addMessage(OpenLMessagesUtils.newWarnMessage((String)message, (ISyntaxNode)syntaxNode));
        }
    }

    @Override
    protected ColumnDescriptor[] makeDescriptors(ITable tableToProcess, IOpenClass tableType, IBindingContext bindingContext, OpenL openl, boolean hasColumnTitleRow, ILogicalTable horizDataTableBody, ILogicalTable descriptorRows, ILogicalTable dataWithTitleRows) throws Exception {
        return DataTableBindHelper.makeDescriptors(bindingContext, tableToProcess, tableType, openl, descriptorRows, dataWithTitleRows, DataTableBindHelper.hasForeignKeysRow(horizDataTableBody), hasColumnTitleRow, false);
    }

    private static class TestedMethodBindingDetails {
        TestMethodBoundNode testMethodBoundNode = null;
        IOpenMethod testedMethod = null;
        TestMethodOpenClass testMethodOpenClass = null;
        ITable dataTable = null;
        Collection<OpenLMessage> messages = null;
        List<SyntaxNodeException> errors = null;

        private TestedMethodBindingDetails() {
        }
    }
}

