/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import org.openl.binding.IBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.rules.data.DataTableBoundNode;
import org.openl.rules.data.ITable;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.DynamicObject;

public class TestMethodBoundNode
extends DataTableBoundNode {
    private TestSuiteMethod testSuiteMethod;

    public TestMethodBoundNode(TableSyntaxNode tableSyntaxNode, XlsModuleOpenClass module) {
        super(tableSyntaxNode, module);
    }

    @Override
    public void addTo(ModuleOpenClass openClass) {
        super.addTo(openClass);
        this.testSuiteMethod.setModuleName(this.getModule().getModuleName());
        openClass.addMethod((IOpenMethod)this.testSuiteMethod);
    }

    protected void setTestSuite(TestSuiteMethod testSuiteMethod) {
        this.testSuiteMethod = testSuiteMethod;
    }

    @Override
    public void finalizeBind(IBindingContext cxt) throws Exception {
        DynamicObject[] testCases;
        super.finalizeBind(cxt);
        for (DynamicObject testCase : testCases = (DynamicObject[])this.getField().getData()) {
            if (testCase.getFieldValue("_error_") == null || testCase.getFieldValue("_res_") == null) continue;
            ITable table = this.getTable();
            int row = table.getRowIndex(testCase);
            int column = table.getColumnIndex("_error_");
            IGridTable cell = (IGridTable)table.getRowTable(row).getColumn(column);
            GridCellSourceCodeModule cellSourceCodeModule = new GridCellSourceCodeModule(cell, cxt);
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Ambiguous expectation in the test case. Both expected result and expected error have been declared.", (IOpenSourceCodeModule)cellSourceCodeModule);
            cxt.addError(error);
        }
    }

    @Override
    public void removeDebugInformation(IBindingContext cxt) throws Exception {
        super.removeDebugInformation(cxt);
        this.testSuiteMethod.clearForExecutionMode();
    }
}

