/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import org.openl.CompiledOpenClass;
import org.openl.rules.testmethod.TestSuite;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.MethodDelegator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProjectHelper {
    private ProjectHelper() {
    }

    public static TestSuiteMethod[] allTesters(IOpenClass openClass) {
        ArrayList<TestSuiteMethod> res = new ArrayList<TestSuiteMethod>();
        for (IOpenMethod tester : openClass.getMethods()) {
            if (ProjectHelper.isTester(tester)) {
                res.add((TestSuiteMethod)tester);
            }
            if (!(tester instanceof OpenMethodDispatcher) || !ProjectHelper.isTester(((OpenMethodDispatcher)tester).getTargetMethod())) continue;
            res.add((TestSuiteMethod)((OpenMethodDispatcher)tester).getTargetMethod());
        }
        TestSuiteMethod[] testSuiteMethods = new TestSuiteMethod[res.size()];
        return res.toArray(testSuiteMethods);
    }

    private static boolean isTester(IOpenMethod tester) {
        if (tester instanceof TestSuiteMethod) {
            try {
                TestSuiteMethod testSuiteMethod = (TestSuiteMethod)tester;
                return !testSuiteMethod.isRunMethod() && testSuiteMethod.isRunmethodTestable();
            }
            catch (Exception e) {
                Logger log = LoggerFactory.getLogger(ProjectHelper.class);
                log.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static IOpenMethod[] testers(IOpenMethod tested, CompiledOpenClass openClass) {
        return (IOpenMethod[])openClass.getOpenClassWithErrors().getMethods().stream().filter(ProjectHelper::isTester).filter(tester -> ProjectHelper.isTestForMethod(tester, tested)).toArray(IOpenMethod[]::new);
    }

    public static boolean isTestForMethod(IOpenMethod tester, IOpenMethod tested) {
        if (!(tester instanceof TestSuiteMethod)) {
            return false;
        }
        IOpenMethod toTest = ((TestSuiteMethod)tester).getTestedMethod();
        if (toTest.equals(tested)) {
            return true;
        }
        if (toTest instanceof OpenMethodDispatcher && ((OpenMethodDispatcher)toTest).getCandidates().contains(tested)) {
            return true;
        }
        if (tested instanceof MethodDelegator) {
            return ProjectHelper.isTestForMethod(tester, tested.getMethod());
        }
        if (tested instanceof OpenMethodDispatcher) {
            return ProjectHelper.isTestForMethod(tester, ((OpenMethodDispatcher)tested).getTargetMethod());
        }
        return false;
    }

    public static String getTestInfo(IOpenMethod testMethod) {
        if (!(testMethod instanceof TestSuiteMethod)) {
            return null;
        }
        return ProjectHelper.getTestInfo(testMethod, ((TestSuiteMethod)testMethod).getNumberOfTestsCases());
    }

    public static String getTestInfo(TestSuite testSuite) {
        return ProjectHelper.getTestInfo((IOpenMethod)testSuite.getTestSuiteMethod(), testSuite.getNumberOfTests());
    }

    private static String getTestInfo(IOpenMethod testMethod, int numberOfTests) {
        String info = null;
        if (testMethod instanceof TestSuiteMethod) {
            TestSuiteMethod testSuite = (TestSuiteMethod)testMethod;
            info = testSuite.isRunMethod() ? (numberOfTests < 1 ? "No runs" : (numberOfTests == 1 ? numberOfTests + " run" : numberOfTests + " runs")) : (numberOfTests < 1 ? "No test cases" : (numberOfTests == 1 ? numberOfTests + " test case" : numberOfTests + " test cases"));
        }
        return info;
    }
}

