/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.meta.StringValue;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.compile.AlgorithmCompiler;
import org.openl.rules.tbasic.compile.AlgorithmCompilerTool;
import org.openl.rules.tbasic.compile.LabelManager;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;

public class ParameterConverterManager {
    private final AlgorithmCompiler compiler;
    private final IOpenClass returnType;
    private final LabelManager labelManager;
    private final Map<Class<?>, ParameterConverter> parameterConverters = new HashMap();

    public ParameterConverterManager(AlgorithmCompiler compiler, IOpenClass returnType) {
        this.parameterConverters.put(String.class, new StringConverter());
        this.parameterConverters.put(Boolean.TYPE, new BooleanConverter());
        this.parameterConverters.put(IMethodCaller.class, new MethodCallerConverter());
        this.compiler = compiler;
        this.returnType = returnType;
        this.labelManager = compiler.getLabelManager();
    }

    public Object convertParam(List<AlgorithmTreeNode> nodesToCompile, Class<?> clazz, String operationParam, IBindingContext bindingContext) {
        ParameterConverter converter = this.parameterConverters.get(clazz);
        if (converter == null) {
            IOpenSourceCodeModule errorSource = nodesToCompile.get(0).getAlgorithmRow().getOperation().asSourceCodeModule();
            BindHelper.processError((String)String.format("Compilation failure. Cannot convert parameter %s to type %s", operationParam, clazz.toString()), (IOpenSourceCodeModule)errorSource, (IBindingContext)bindingContext);
        }
        return converter.convert(nodesToCompile, operationParam, bindingContext);
    }

    private final class MethodCallerConverter
    implements ParameterConverter {
        private MethodCallerConverter() {
        }

        @Override
        public Object convert(List<AlgorithmTreeNode> nodesToCompile, String operationParam, IBindingContext bindingContext) {
            if (operationParam == null) {
                return null;
            }
            StringValue cellContent = AlgorithmCompilerTool.getCellContent(nodesToCompile, operationParam, bindingContext);
            AlgorithmTreeNode executionNode = AlgorithmCompilerTool.extractOperationNode(nodesToCompile, operationParam, bindingContext);
            String methodName = String.format("%s_row_%s", operationParam.replace('.', '_'), executionNode.getAlgorithmRow().getRowNumber());
            IOpenSourceCodeModule src = cellContent.getMetaInfo().getSource();
            if (ParameterConverterManager.this.labelManager.isReturnInstruction(operationParam)) {
                return ParameterConverterManager.this.compiler.makeMethodWithCast(src, methodName, ParameterConverterManager.this.returnType);
            }
            return ParameterConverterManager.this.compiler.makeMethod(src, methodName);
        }
    }

    private static final class BooleanConverter
    implements ParameterConverter {
        private BooleanConverter() {
        }

        @Override
        public Object convert(List<AlgorithmTreeNode> nodesToCompile, String operationParam, IBindingContext bindingContext) {
            return Boolean.parseBoolean(operationParam);
        }
    }

    private final class StringConverter
    implements ParameterConverter {
        private StringConverter() {
        }

        @Override
        public Object convert(List<AlgorithmTreeNode> nodesToCompile, String operationParam, IBindingContext bindingContext) {
            if (ParameterConverterManager.this.labelManager.isLabelInstruction(operationParam)) {
                return ParameterConverterManager.this.labelManager.getLabelByInstruction(operationParam);
            }
            if (AlgorithmCompilerTool.isOperationFieldInstruction(operationParam)) {
                StringValue content = AlgorithmCompilerTool.getCellContent(nodesToCompile, operationParam, bindingContext);
                return content.getValue();
            }
            return operationParam;
        }
    }

    public static interface ParameterConverter {
        public Object convert(List<AlgorithmTreeNode> var1, String var2, IBindingContext var3);
    }
}

