/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openl.util.StringUtils;

public abstract class DataTableField {
    private final String name;
    private String businessName;
    private String foreignKeyTable;
    private String foreignKeyColumn;
    private List<DataTableField> aggregatedFields = new ArrayList<DataTableField>();

    public DataTableField(String name, String businessName) {
        this.name = name;
        this.businessName = businessName;
    }

    public String getName() {
        return this.name;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public String getForeignKeyTable() {
        return this.foreignKeyTable;
    }

    public void setForeignKeyTable(String foreignKeyTable) {
        this.foreignKeyTable = foreignKeyTable;
    }

    public String getForeignKeyColumn() {
        return this.foreignKeyColumn;
    }

    public void setForeignKeyColumn(String foreignKeyColumn) {
        this.foreignKeyColumn = foreignKeyColumn;
    }

    public String getForeignKey() {
        if (StringUtils.isBlank((CharSequence)this.foreignKeyTable)) {
            return null;
        }
        String fk = ">" + this.foreignKeyTable;
        if (StringUtils.isNotBlank((CharSequence)this.foreignKeyColumn)) {
            fk = fk + " " + this.foreignKeyColumn;
        }
        return fk;
    }

    public List<DataTableField> getAggregatedFields() {
        return this.aggregatedFields;
    }

    public void setAggregatedFields(List<DataTableField> aggregatedFields) {
        this.aggregatedFields = aggregatedFields;
    }

    public boolean isFillChildren() {
        return !this.getAggregatedFields().isEmpty();
    }

    public void useAggregatedFields() {
        this.setAggregatedFields(this.getAvailableFields());
    }

    public void useForeignKey() {
        this.setAggregatedFields(Collections.emptyList());
    }

    public abstract String getTypeName();

    public abstract boolean isComplex();

    protected abstract List<DataTableField> getAvailableFields();
}

