/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFOptimiser;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class PoiExcelHelper {
    private static final short MAX_STYLES = 4030;

    private PoiExcelHelper() {
    }

    public static void copyCellValue(Cell cellFrom, Cell cellTo) {
        cellTo.setBlank();
        switch (cellFrom.getCellType()) {
            case BLANK: {
                break;
            }
            case BOOLEAN: {
                cellTo.setCellValue(cellFrom.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                cellTo.setCellFormula(cellFrom.getCellFormula());
                try {
                    PoiExcelHelper.evaluateFormula(cellTo);
                }
                catch (Exception exception) {}
                break;
            }
            case NUMERIC: {
                cellTo.setCellValue(cellFrom.getNumericCellValue());
                break;
            }
            case STRING: {
                cellTo.setCellValue(cellFrom.getRichStringCellValue());
                break;
            }
            default: {
                throw new RuntimeException("Unknown cell type: " + cellFrom.getCellType());
            }
        }
    }

    public static void copyCellStyle(Cell cellFrom, Cell cellTo, Sheet sheetTo) {
        CellStyle styleFrom = cellFrom.getCellStyle();
        try {
            cellTo.setCellStyle(styleFrom);
        }
        catch (IllegalArgumentException e) {
            Object styleTo = PoiExcelHelper.createCellStyle(sheetTo.getWorkbook());
            styleTo.cloneStyleFrom(styleFrom);
            cellTo.setCellStyle(styleTo);
        }
    }

    public static Cell getCell(int colIndex, int rowIndex, Sheet sheet) {
        Row row = sheet.getRow(rowIndex);
        if (row != null) {
            return row.getCell(colIndex, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
        }
        return null;
    }

    public static Cell getOrCreateCell(int colIndex, int rowIndex, Sheet sheet) {
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row.getCell(colIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
    }

    public static int getColumnWidth(int col, Sheet sheet) {
        int w = sheet.getColumnWidth((int)((short)col));
        if (w == sheet.getDefaultColumnWidth()) {
            return 79;
        }
        return w / 40;
    }

    public static int getMaxColumnIndex(int rownum, Sheet sheet) {
        Row row = sheet.getRow(rownum);
        return row == null ? (short)0 : row.getLastCellNum();
    }

    public static int getMaxRowIndex(Sheet sheet) {
        return sheet.getLastRowNum();
    }

    public static int getMinColumnIndex(int rownum, Sheet sheet) {
        Row row = sheet.getRow(rownum);
        return row == null ? (short)0 : row.getFirstCellNum();
    }

    public static int getNumberOfMergedRegions(Sheet sheet) {
        try {
            return sheet.getNumMergedRegions();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public static int getMinRowIndex(Sheet sheet) {
        return sheet.getFirstRowNum();
    }

    public static int getLastRowNum(Sheet sheet) {
        return sheet.getLastRowNum();
    }

    public static void setCellStringValue(int col, int row, String value, Sheet sheet) {
        Cell cell = PoiExcelHelper.getOrCreateCell(col, row, sheet);
        cell.setCellType(CellType.STRING);
        cell.setCellValue(value);
    }

    public static CellRangeAddress getMergedRegionAt(int index, Sheet sheet) {
        return sheet.getMergedRegion(index);
    }

    public static void evaluateFormula(Cell cell) {
        FormulaEvaluator formulaEvaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        formulaEvaluator.evaluateFormulaCell(cell);
    }

    public static <T extends CellStyle> T createCellStyle(Workbook workbook) {
        if (workbook instanceof HSSFWorkbook) {
            if (workbook.getNumCellStyles() == 4030) {
                HSSFOptimiser.optimiseCellStyles((HSSFWorkbook)((HSSFWorkbook)workbook));
            }
            CellStyle style = workbook.createCellStyle();
            return (T)style;
        }
        CellStyle style = workbook.createCellStyle();
        return (T)style;
    }

    public static CellStyle cloneStyleFrom(Cell cell) {
        CellStyle newStyle = null;
        if (cell != null) {
            Sheet sheet = cell.getSheet();
            newStyle = (CellStyle)PoiExcelHelper.createCellStyle(sheet.getWorkbook());
            CellStyle fromStyle = cell.getCellStyle();
            newStyle.cloneStyleFrom(fromStyle);
        }
        return newStyle;
    }

    public static Font cloneFontFrom(Cell cell) {
        Font newFont = null;
        if (cell != null) {
            Workbook workbook = cell.getSheet().getWorkbook();
            newFont = workbook.createFont();
            int fontIndex = cell.getCellStyle().getFontIndexAsInt();
            Font fromFont = workbook.getFontAt(fontIndex);
            newFont.setBold(fromFont.getBold());
            newFont.setColor(fromFont.getColor());
            newFont.setFontHeight(fromFont.getFontHeight());
            newFont.setFontName(fromFont.getFontName());
            newFont.setItalic(fromFont.getItalic());
            newFont.setStrikeout(fromFont.getStrikeout());
            newFont.setTypeOffset(fromFont.getTypeOffset());
            newFont.setUnderline(fromFont.getUnderline());
            newFont.setCharSet(fromFont.getCharSet());
        }
        return newFont;
    }

    public static Font getCellFont(Cell cell) {
        Font font = null;
        if (cell != null) {
            CellStyle style = cell.getCellStyle();
            int fontIndex = style.getFontIndexAsInt();
            font = cell.getSheet().getWorkbook().getFontAt(fontIndex);
        }
        return font;
    }

    public static void setCellFont(Cell cell, boolean boldWeight, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        if (cell != null) {
            Workbook workbook = cell.getSheet().getWorkbook();
            Font font = workbook.findFont(boldWeight, color, fontHeight, name, italic, strikeout, typeOffset, underline);
            if (font == null) {
                font = cell.getSheet().getWorkbook().createFont();
                font.setBold(boldWeight);
                font.setColor(color);
                font.setFontHeight(fontHeight);
                font.setFontName(name);
                font.setItalic(italic);
                font.setStrikeout(strikeout);
                font.setTypeOffset(typeOffset);
                font.setUnderline(underline);
            }
            CellUtil.setFont((Cell)cell, (Font)font);
        }
    }

    public static void setCellFontBold(Cell cell, boolean boldweight) {
        Font font = PoiExcelHelper.getCellFont(cell);
        if (font != null) {
            PoiExcelHelper.setCellFont(cell, boldweight, font.getColor(), font.getFontHeight(), font.getFontName(), font.getItalic(), font.getStrikeout(), font.getTypeOffset(), font.getUnderline());
        }
    }

    public static void setCellFontItalic(Cell cell, boolean italic) {
        Font font = PoiExcelHelper.getCellFont(cell);
        if (font != null) {
            PoiExcelHelper.setCellFont(cell, font.getBold(), font.getColor(), font.getFontHeight(), font.getFontName(), italic, font.getStrikeout(), font.getTypeOffset(), font.getUnderline());
        }
    }

    public static void setCellFontUnderline(Cell cell, byte underline) {
        Font font = PoiExcelHelper.getCellFont(cell);
        if (font != null) {
            PoiExcelHelper.setCellFont(cell, font.getBold(), font.getColor(), font.getFontHeight(), font.getFontName(), font.getItalic(), font.getStrikeout(), font.getTypeOffset(), underline);
        }
    }

    public static short[] toRgb(Color color) {
        byte[] rgb;
        if (color == null) {
            return null;
        }
        if (color instanceof HSSFColor) {
            return ((HSSFColor)color).getTriplet();
        }
        if (color instanceof XSSFColor && (rgb = ((XSSFColor)color).getRGB()) != null) {
            return PoiExcelHelper.applyTint(rgb, ((XSSFColor)color).getTint());
        }
        return null;
    }

    private static short[] applyTint(byte[] rgb, double tint) {
        short red = PoiExcelHelper.toShort(rgb[0]);
        short green = PoiExcelHelper.toShort(rgb[1]);
        short blue = PoiExcelHelper.toShort(rgb[2]);
        if (tint == 0.0) {
            return new short[]{red, green, blue};
        }
        if (red == green && green == blue) {
            double newLum = PoiExcelHelper.calculateLum(red, tint);
            short v = PoiExcelHelper.toShort(newLum);
            return new short[]{v, v, v};
        }
        short max = green;
        short min = red;
        if (red > green) {
            max = red;
            min = green;
        }
        if (blue > max) {
            max = blue;
        } else if (blue < min) {
            min = blue;
        }
        int chroma = max - min;
        int lum = max + min;
        double newLum = PoiExcelHelper.calculateLum(lum / 2, tint) * 2.0;
        double x = (255.0 - Math.abs(newLum - 255.0)) / (double)(255 - Math.abs(lum - 255));
        double m = (newLum - x * (double)chroma) / 2.0;
        short r = PoiExcelHelper.toShort((double)(red - min) * x + m);
        short g = PoiExcelHelper.toShort((double)(green - min) * x + m);
        short b = PoiExcelHelper.toShort((double)(blue - min) * x + m);
        return new short[]{r, g, b};
    }

    private static double calculateLum(int lum, double tint) {
        if (tint < 0.0) {
            return (double)lum * (1.0 + tint);
        }
        return (double)(lum - 255) * (1.0 - tint) + 255.0;
    }

    private static short toShort(double value) {
        if (value >= 255.0) {
            return 255;
        }
        if (value <= 0.0) {
            return 0;
        }
        return (short)Math.round(value);
    }

    private static short toShort(byte value) {
        return (short)(value & 0xFF);
    }

    public static short[] toRgb(short colorIndex, HSSFWorkbook workbook) {
        HSSFColor cc = workbook.getCustomPalette().getColor(colorIndex);
        return PoiExcelHelper.toRgb((Color)cc);
    }

    public static short[] getFontColor(Font font, Workbook workbook) {
        if (font instanceof XSSFFont) {
            XSSFColor color = ((XSSFFont)font).getXSSFColor();
            return PoiExcelHelper.toRgb((Color)color);
        }
        short x = font.getColor();
        return PoiExcelHelper.toRgb(x, (HSSFWorkbook)workbook);
    }

    public static short[][] getCellBorderColors(CellStyle style, Workbook workbook) {
        short[][] colors = new short[4][];
        if (style instanceof HSSFCellStyle) {
            HSSFWorkbook hssfWorkbook = (HSSFWorkbook)workbook;
            colors[0] = PoiExcelHelper.toRgb(style.getTopBorderColor(), hssfWorkbook);
            colors[1] = PoiExcelHelper.toRgb(style.getRightBorderColor(), hssfWorkbook);
            colors[2] = PoiExcelHelper.toRgb(style.getBottomBorderColor(), hssfWorkbook);
            colors[3] = PoiExcelHelper.toRgb(style.getLeftBorderColor(), hssfWorkbook);
        } else if (style instanceof XSSFCellStyle) {
            XSSFCellStyle xssfStyle = (XSSFCellStyle)style;
            colors[0] = PoiExcelHelper.toRgb((Color)xssfStyle.getTopBorderXSSFColor());
            colors[1] = PoiExcelHelper.toRgb((Color)xssfStyle.getRightBorderXSSFColor());
            colors[2] = PoiExcelHelper.toRgb((Color)xssfStyle.getBottomBorderXSSFColor());
            colors[3] = PoiExcelHelper.toRgb((Color)xssfStyle.getLeftBorderXSSFColor());
        }
        return colors;
    }

    public static BorderStyle[] getCellBorderStyles(CellStyle style) {
        BorderStyle[] styles = new BorderStyle[]{style.getBorderTop(), style.getBorderRight(), style.getBorderBottom(), style.getBorderLeft()};
        return styles;
    }

    public static void setCellBorderColors(CellStyle style, short[][] colors, Workbook workbook) {
        if (style instanceof HSSFCellStyle) {
            HSSFWorkbook hssfWorkbook = (HSSFWorkbook)workbook;
            if (colors[0] != null) {
                style.setTopBorderColor(PoiExcelHelper.getOrAddColorIndex(colors[0], hssfWorkbook));
            }
            if (colors[1] != null) {
                style.setRightBorderColor(PoiExcelHelper.getOrAddColorIndex(colors[1], hssfWorkbook));
            }
            if (colors[2] != null) {
                style.setBottomBorderColor(PoiExcelHelper.getOrAddColorIndex(colors[2], hssfWorkbook));
            }
            if (colors[3] != null) {
                style.setLeftBorderColor(PoiExcelHelper.getOrAddColorIndex(colors[3], hssfWorkbook));
            }
        } else if (style instanceof XSSFCellStyle) {
            XSSFWorkbook xssfWorkbook = (XSSFWorkbook)workbook;
            XSSFCellStyle xssfStyle = (XSSFCellStyle)style;
            if (colors[0] != null) {
                xssfStyle.setTopBorderColor(PoiExcelHelper.getColor(colors[0], xssfWorkbook));
            }
            if (colors[1] != null) {
                xssfStyle.setRightBorderColor(PoiExcelHelper.getColor(colors[1], xssfWorkbook));
            }
            if (colors[2] != null) {
                xssfStyle.setBottomBorderColor(PoiExcelHelper.getColor(colors[2], xssfWorkbook));
            }
            if (colors[3] != null) {
                xssfStyle.setLeftBorderColor(PoiExcelHelper.getColor(colors[3], xssfWorkbook));
            }
        }
    }

    public static XSSFColor getColor(short[] color, XSSFWorkbook workbook) {
        byte[] rgb = new byte[3];
        for (int i = 0; i < 3; ++i) {
            rgb[i] = (byte)(color[i] & 0xFF);
        }
        IndexedColorMap indexedColors = workbook.getStylesSource().getIndexedColors();
        XSSFColor xssfColor = new XSSFColor(indexedColors);
        xssfColor.setRGB(rgb);
        return xssfColor;
    }

    private static short getOrAddColorIndex(short[] rgb, HSSFWorkbook wb) {
        HSSFPalette palette = wb.getCustomPalette();
        HSSFColor color = palette.findColor((byte)rgb[0], (byte)rgb[1], (byte)rgb[2]);
        if (color == null) {
            try {
                color = palette.addColor((byte)rgb[0], (byte)rgb[1], (byte)rgb[2]);
            }
            catch (RuntimeException e) {
                color = palette.findSimilarColor((int)rgb[0], (int)rgb[1], (int)rgb[2]);
            }
        }
        return color.getIndex();
    }
}

