/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.formatters;

import java.math.BigDecimal;
import java.util.Locale;
import org.openl.meta.BigDecimalValue;
import org.openl.rules.helpers.NumberUtils;
import org.openl.util.formatters.IFormatter;
import org.openl.util.formatters.NumberFormatter;

public class SmartNumberFormatter
implements IFormatter {
    private final Locale locale;

    public SmartNumberFormatter() {
        this.locale = Locale.US;
    }

    public SmartNumberFormatter(Locale locale) {
        this.locale = locale;
    }

    public String format(Object value) {
        if (!(value instanceof Number)) {
            return null;
        }
        String format = SmartNumberFormatter.getFormatForScale((Number)value);
        Number processedValue = SmartNumberFormatter.getProcessedValue((Number)value);
        NumberFormatter formatter = new NumberFormatter(format, this.locale);
        return formatter.format((Object)processedValue);
    }

    public Object parse(String value) {
        throw new UnsupportedOperationException();
    }

    private static Number getProcessedValue(Number value) {
        if (value == null) {
            throw new NullPointerException("Null value is not supported");
        }
        if (value instanceof BigDecimal) {
            return value;
        }
        if (value instanceof BigDecimalValue) {
            return value;
        }
        if (NumberUtils.isObjectFloatPointNumber(value)) {
            int scale;
            double d;
            double d1 = d = NumberUtils.convertToDouble(value).doubleValue();
            double d2 = d;
            int bestScale = scale = NumberUtils.getScale(d);
            double best = d;
            for (int i = 0; i < 2; ++i) {
                d1 -= Math.ulp(d1);
                d2 += Math.ulp(d2);
                int s = NumberUtils.getScale(d1);
                if (s < bestScale) {
                    bestScale = s;
                    best = d1;
                }
                if ((s = NumberUtils.getScale(d2)) >= bestScale) continue;
                bestScale = s;
                best = d2;
            }
            if (scale - bestScale > 1) {
                return best;
            }
            return d;
        }
        return value;
    }

    private static int getScale(Number value) {
        if (value == null) {
            throw new NullPointerException("Null value is not supported");
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).scale();
        }
        if (value instanceof BigDecimalValue) {
            return ((BigDecimalValue)value).getValue().scale();
        }
        if (NumberUtils.isObjectFloatPointNumber(value)) {
            int scale;
            double d;
            double d1 = d = NumberUtils.convertToDouble(value).doubleValue();
            double d2 = d;
            int bestScale = scale = NumberUtils.getScale(d);
            for (int i = 0; i < 2; ++i) {
                d1 -= Math.ulp(d1);
                d2 += Math.ulp(d2);
                int s = NumberUtils.getScale(d1);
                if (s < bestScale) {
                    bestScale = s;
                }
                if ((s = NumberUtils.getScale(d2)) >= bestScale) continue;
                bestScale = s;
            }
            if (scale - bestScale > 1) {
                return bestScale;
            }
            return scale;
        }
        return BigDecimal.valueOf(value.longValue()).scale();
    }

    private static String getFormatForScale(Number value) {
        if (value != null) {
            int scale = SmartNumberFormatter.getScale(value);
            StringBuilder buf = new StringBuilder();
            buf.append("#");
            if (scale > 0) {
                buf.append(".");
                for (int i = 0; i < scale; ++i) {
                    buf.append("#");
                }
            }
            return buf.toString();
        }
        return null;
    }
}

