/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.openl.rules.table.AGrid;
import org.openl.rules.table.CompositeCell;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.xls.XlsSheetGridModel;

public class CompositeGrid
extends AGrid {
    private final IGridTable[] gridTables;
    private IGridRegion[] mappedRegions;
    private IGridRegion[] mergedRegions;
    private final boolean vertical;
    private int width;
    private int height;

    public IGridTable[] getGridTables() {
        return this.gridTables;
    }

    public IGridRegion getMappedRegion(int i) {
        return this.mappedRegions[i];
    }

    public CompositeGrid(IGridTable[] tables, boolean vertical) {
        this.gridTables = tables;
        this.vertical = vertical;
        this.init();
    }

    @Override
    public ICell getCell(int column, int row) {
        Transform t = this.transform(column, row);
        if (t == null) {
            return null;
        }
        ICell delegate = t.grid().getCell(t.getCol(), t.getRow());
        return new CompositeCell(column, row, this.getRegionContaining(column, row), delegate, t.getGridTable());
    }

    @Override
    public int getColumnWidth(int col) {
        Transform t = this.transform(col, 0);
        return t == null ? 100 : t.grid().getColumnWidth(t.getCol());
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public int getMaxColumnIndex(int row) {
        return this.width - 1;
    }

    @Override
    public int getMaxRowIndex() {
        return this.height - 1;
    }

    @Override
    public IGridRegion getMergedRegion(int i) {
        return this.mergedRegions[i];
    }

    @Override
    public int getMinColumnIndex(int row) {
        return 0;
    }

    @Override
    public int getMinRowIndex() {
        return 0;
    }

    @Override
    public int getNumberOfMergedRegions() {
        return this.mergedRegions.length;
    }

    @Override
    public String getRangeUri(int colStart, int rowStart, int colEnd, int rowEnd) {
        Transform t1 = this.transform(colStart, rowStart);
        Transform t2 = this.transform(colEnd, rowEnd);
        if (t1 == null || t2 == null) {
            return null;
        }
        if (t1.grid() != t2.grid() || this.isGenerated(t1.grid()) || this.isGenerated(t2.grid())) {
            int h = 0;
            int w = 0;
            for (IGridTable gridTable : this.gridTables) {
                Transform g2;
                Transform g1;
                if (this.isGenerated(gridTable.getGrid())) {
                    h += gridTable.getHeight();
                    w += gridTable.getWidth();
                    continue;
                }
                if (this.vertical) {
                    g1 = this.transform(colStart, h);
                    g2 = this.transform(colEnd, h);
                } else {
                    g1 = this.transform(w, rowStart);
                    g2 = this.transform(w, rowEnd);
                }
                return g1.grid().getRangeUri(g1.getCol(), g1.getRow(), g2.getCol(), g2.getRow());
            }
        }
        return t1.grid().getRangeUri(t1.getCol(), t1.getRow(), t2.getCol(), t2.getRow());
    }

    private boolean isGenerated(IGrid grid) {
        if (grid instanceof XlsSheetGridModel) {
            return ((XlsSheetGridModel)grid).getSheetSource().getWorkbookSource().getUri() == null;
        }
        return false;
    }

    @Override
    public String getUri() {
        Transform t = this.transform(0, 0);
        return t == null ? null : t.grid().getUri();
    }

    public int getWidth() {
        return this.width;
    }

    private void init() {
        this.initWidthAndHeight();
        this.initMappedRegions();
        this.initMergedRegions();
    }

    private void initMergedRegions() {
        ArrayList<GridRegion> mergedRegionsList = new ArrayList<GridRegion>();
        Set<IGrid> gridSet = this.getGridSet();
        for (IGrid grid : gridSet) {
            for (int i = 0; i < grid.getNumberOfMergedRegions(); ++i) {
                IGridRegion mergedRegion = grid.getMergedRegion(i);
                for (int j = 0; j < this.gridTables.length; ++j) {
                    int dy;
                    int dx;
                    IGridRegion tableRegion;
                    IGridRegion intersection;
                    if (this.gridTables[j].getGrid() != grid || (intersection = IGridRegion.Tool.intersect(mergedRegion, tableRegion = this.gridTables[j].getRegion())) == null) continue;
                    if (!this.gridTables[j].isNormalOrientation()) {
                        int left = intersection.getTop();
                        int top = intersection.getLeft();
                        int right = intersection.getBottom();
                        int bottom = intersection.getRight();
                        intersection = new GridRegion(top, left, bottom, right);
                    }
                    if (!this.gridTables[j].isNormalOrientation()) {
                        dx = this.mappedRegions[j].getLeft() - tableRegion.getTop();
                        dy = this.mappedRegions[j].getTop() - tableRegion.getLeft();
                    } else {
                        dx = this.mappedRegions[j].getLeft() - tableRegion.getLeft();
                        dy = this.mappedRegions[j].getTop() - tableRegion.getTop();
                    }
                    GridRegion moved = IGridRegion.Tool.move(intersection, dx, dy);
                    mergedRegionsList.add(moved);
                }
            }
        }
        this.mergedRegions = mergedRegionsList.toArray(IGridRegion.EMPTY_REGION);
    }

    private Set<IGrid> getGridSet() {
        HashSet<IGrid> gridSet = new HashSet<IGrid>();
        for (IGridTable gridTable : this.gridTables) {
            gridSet.add(gridTable.getGrid());
        }
        return gridSet;
    }

    private void initMappedRegions() {
        this.mappedRegions = new GridRegion[this.gridTables.length];
        int w = 0;
        int h = 0;
        for (int i = 0; i < this.gridTables.length; ++i) {
            GridRegion mapped;
            int last;
            IGridRegion reg = this.gridTables[i].getRegion();
            int n = last = i == this.gridTables.length - 1 ? 1 : 0;
            if (this.vertical) {
                int rh = IGridRegion.Tool.height(reg);
                mapped = new GridRegion(h, 0, h + rh - 1 + last, this.width);
                h += rh;
            } else {
                int rw = IGridRegion.Tool.width(reg);
                mapped = new GridRegion(0, w, this.height, w + rw - 1 + last);
                w += rw;
            }
            this.mappedRegions[i] = mapped;
        }
    }

    private void initWidthAndHeight() {
        for (IGridTable gridTable : this.gridTables) {
            IGridRegion reg = gridTable.getRegion();
            if (this.vertical) {
                this.height += IGridRegion.Tool.height(reg);
                this.width = Math.max(this.width, IGridRegion.Tool.width(reg));
                continue;
            }
            this.width += IGridRegion.Tool.width(reg);
            this.height = Math.max(this.height, IGridRegion.Tool.height(reg));
        }
    }

    @Override
    public boolean isEmpty(int col, int row) {
        Transform t = this.transform(col, row);
        return t == null || t.grid().isEmpty(t.getCol(), t.getRow());
    }

    public Transform transform(int col, int row) {
        for (int i = 0; i < this.mappedRegions.length; ++i) {
            int transformedRow;
            int transformedCol;
            if (!IGridRegion.Tool.contains(this.mappedRegions[i], col, row)) continue;
            IGridRegion reg = this.gridTables[i].getRegion();
            if (this.gridTables[i].isNormalOrientation()) {
                transformedCol = reg.getLeft() + col - this.mappedRegions[i].getLeft();
                transformedRow = reg.getTop() + row - this.mappedRegions[i].getTop();
            } else {
                transformedCol = ((IGridTable)this.gridTables[i].transpose()).getRegion().getLeft() + row - this.mappedRegions[i].getTop();
                transformedRow = ((IGridTable)this.gridTables[i].transpose()).getRegion().getTop() + col - this.mappedRegions[i].getLeft();
            }
            return new Transform(this.gridTables[i].getGrid(), this.gridTables[i], transformedCol, transformedRow);
        }
        return null;
    }

    protected static class Transform {
        private final IGrid grid;
        private final int col;
        private final int row;
        private final IGridTable gridTable;

        public Transform(IGrid grid, IGridTable gridTable, int col, int row) {
            this.grid = grid;
            this.gridTable = gridTable;
            this.col = col;
            this.row = row;
        }

        public IGrid grid() {
            return this.grid;
        }

        public int getCol() {
            return this.col;
        }

        public int getRow() {
            return this.row;
        }

        public IGridTable getGridTable() {
            return this.gridTable;
        }
    }
}

