/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.runtime;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import org.openl.CompiledOpenClass;
import org.openl.ICompileContext;
import org.openl.binding.IBindingContext;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.context.IRulesRuntimeContextProvider;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.runtime.InterfaceClassGenerator;
import org.openl.rules.runtime.InterfaceClassGeneratorImpl;
import org.openl.rules.runtime.OpenLRulesMethodHandler;
import org.openl.rules.vm.SimpleRulesVM;
import org.openl.runtime.EngineFactory;
import org.openl.runtime.IEngineWrapper;
import org.openl.runtime.IOpenLMethodHandler;
import org.openl.runtime.IRuntimeEnvBuilder;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.validation.ValidatedCompiledOpenClass;
import org.openl.validation.ValidationManager;
import org.openl.vm.IRuntimeEnv;
import org.openl.xls.RulesCompileContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesEngineFactory<T>
extends EngineFactory<T> {
    private final Logger log = LoggerFactory.getLogger(RulesEngineFactory.class);
    private static final String RULES_XLS_OPENL_NAME = "org.openl.xls";
    private InterfaceClassGenerator interfaceClassGenerator = new InterfaceClassGeneratorImpl();
    private IRuntimeEnvBuilder runtimeEnvBuilder = null;

    public void setInterfaceClassGenerator(InterfaceClassGenerator interfaceClassGenerator) {
        this.interfaceClassGenerator = Objects.requireNonNull(interfaceClassGenerator, "interfaceClassGenerator cannot be null");
    }

    public InterfaceClassGenerator getInterfaceClassGenerator() {
        return this.interfaceClassGenerator;
    }

    public RulesEngineFactory(String sourceFile) {
        super(RULES_XLS_OPENL_NAME, sourceFile);
    }

    public RulesEngineFactory(String sourceFile, Class<T> interfaceClass) {
        super(RULES_XLS_OPENL_NAME, sourceFile, interfaceClass);
    }

    public RulesEngineFactory(String sourceFile, String userHome) {
        super(RULES_XLS_OPENL_NAME, sourceFile, userHome);
    }

    public RulesEngineFactory(String sourceFile, String userHome, Class<T> interfaceClass) {
        super(RULES_XLS_OPENL_NAME, sourceFile, userHome);
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(IOpenSourceCodeModule sourceCodeModule) {
        super(RULES_XLS_OPENL_NAME, sourceCodeModule);
    }

    public RulesEngineFactory(IOpenSourceCodeModule sourceCodeModule, Class<T> interfaceClass) {
        super(RULES_XLS_OPENL_NAME, sourceCodeModule);
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(IOpenSourceCodeModule source, String userHome) {
        super(RULES_XLS_OPENL_NAME, source, userHome);
    }

    public RulesEngineFactory(IOpenSourceCodeModule source, String userHome, Class<T> interfaceClass) {
        super(RULES_XLS_OPENL_NAME, source, userHome);
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(URL source) {
        super(RULES_XLS_OPENL_NAME, source);
    }

    public RulesEngineFactory(URL source, Class<T> interfaceClass) {
        super(RULES_XLS_OPENL_NAME, source);
        Objects.requireNonNull(interfaceClass, "interfaceClass cannot be null");
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(String openlName, IOpenSourceCodeModule sourceCode, Class<T> interfaceClass) {
        super(openlName, sourceCode);
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(String openlName, IOpenSourceCodeModule sourceCode) {
        super(openlName, sourceCode);
    }

    public RulesEngineFactory(String openlName, String userHome, IOpenSourceCodeModule sourceCode, Class<T> interfaceClass) {
        super(openlName, sourceCode, userHome);
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(String openlName, String userHome, IOpenSourceCodeModule sourceCode) {
        super(openlName, sourceCode, userHome);
    }

    public RulesEngineFactory(String openlName, String userHome, String sourceFile, Class<T> interfaceClass) {
        super(openlName, sourceFile, userHome);
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(String openlName, String userHome, String sourceFile) {
        super(openlName, sourceFile, userHome);
    }

    public RulesEngineFactory(IOpenSourceCodeModule source, String userHome, String openlName) {
        super(openlName, source, userHome);
    }

    public void reset(boolean resetInterface) {
        super.reset();
        if (resetInterface) {
            this.setInterfaceClass(null);
        }
    }

    public Class<T> getInterfaceClass() {
        if (super.getInterfaceClass() == null) {
            IOpenClass openClass = this.getCompiledOpenClass().getOpenClassWithErrors();
            String className = openClass.getName();
            ClassLoader classLoader = this.getCompiledOpenClass().getClassLoader();
            try {
                try {
                    Class<?> interfaceClass = classLoader.loadClass(className);
                    this.log.warn("Previously generated interface '{}' has been used as a service class.", (Object)className);
                    this.setInterfaceClass(interfaceClass);
                    return interfaceClass;
                }
                catch (ClassNotFoundException e) {
                    Class<?> interfaceClass = this.interfaceClassGenerator.generateInterface(className, openClass, classLoader);
                    this.setInterfaceClass(interfaceClass);
                    return interfaceClass;
                }
            }
            catch (Exception e) {
                throw new OpenlNotCheckedException("Failed to generate the interface '" + className + "'", (Throwable)e);
            }
        }
        return super.getInterfaceClass();
    }

    protected Class<?>[] prepareInstanceInterfaces() {
        return new Class[]{this.getInterfaceClass(), IEngineWrapper.class, IRulesRuntimeContextProvider.class};
    }

    protected IRuntimeEnvBuilder getRuntimeEnvBuilder() {
        if (this.runtimeEnvBuilder == null) {
            this.runtimeEnvBuilder = () -> new SimpleRulesVM().getRuntimeEnv();
        }
        return this.runtimeEnvBuilder;
    }

    protected IOpenLMethodHandler prepareMethodHandler(Object openClassInstance, Map<Method, IOpenMember> methodMap, IRuntimeEnv runtimeEnv) {
        return new OpenLRulesMethodHandler(openClassInstance, runtimeEnv, methodMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompiledOpenClass initializeOpenClass() {
        CompiledOpenClass compiledOpenClass;
        boolean oldValidationState = ValidationManager.isValidationEnabled();
        try {
            ValidationManager.turnOffValidation();
            compiledOpenClass = super.initializeOpenClass();
        }
        finally {
            if (oldValidationState) {
                ValidationManager.turnOnValidation();
            }
        }
        try {
            if (oldValidationState) {
                IBindingContext bindingContext = this.getOpenL().getBinder().makeBindingContext();
                bindingContext.setExecutionMode(this.isExecutionMode());
                ValidationManager.validate((ICompileContext)new RulesCompileContext(), (IOpenClass)compiledOpenClass.getOpenClassWithErrors(), (IBindingContext)bindingContext);
                ValidatedCompiledOpenClass validatedCompiledOpenClass = ValidatedCompiledOpenClass.instanceOf((CompiledOpenClass)compiledOpenClass);
                if (bindingContext.getMessages() != null) {
                    bindingContext.getMessages().forEach(arg_0 -> ((ValidatedCompiledOpenClass)validatedCompiledOpenClass).addMessage(arg_0));
                }
                ValidatedCompiledOpenClass validatedCompiledOpenClass2 = validatedCompiledOpenClass;
                return validatedCompiledOpenClass2;
            }
            CompiledOpenClass compiledOpenClass2 = compiledOpenClass;
            return compiledOpenClass2;
        }
        finally {
            if (this.isExecutionMode()) {
                ((XlsModuleOpenClass)compiledOpenClass.getOpenClassWithErrors()).clearForExecutionMode();
            }
        }
    }
}

