/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types.meta;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.IMetaInfo;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableBoundNode;
import org.openl.rules.dt.DecisionTableHelper;
import org.openl.rules.dt.IBaseAction;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.IBaseDecisionRow;
import org.openl.rules.dt.element.ArrayHolder;
import org.openl.rules.dt.element.FunctionalRow;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.AMethodMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.MetaInfoReaderUtils;
import org.openl.rules.table.CellKey;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionTableMetaInfoReader
extends AMethodMetaInfoReader<DecisionTableBoundNode> {
    private final Logger log = LoggerFactory.getLogger(DecisionTableMetaInfoReader.class);
    private final DecisionTable decisionTable;
    private CellMetaInfo[][] preparedMetaInfos;
    private int top;
    private int left;
    private final Deque<MetaInfoHolder> stack;

    public DecisionTableMetaInfoReader(DecisionTableBoundNode boundNode) {
        this(boundNode, null);
    }

    public DecisionTableMetaInfoReader(DecisionTableBoundNode boundNode, DecisionTable decisionTable) {
        super(boundNode);
        this.decisionTable = decisionTable;
        this.stack = new ArrayDeque<MetaInfoHolder>();
        this.stack.push(new MetaInfoHolder());
    }

    public void pushMetaInfos() {
        this.stack.push(new MetaInfoHolder());
    }

    public MetaInfoHolder popMetaInfos() {
        return this.stack.pop();
    }

    public MetaInfoHolder getMetaInfos() {
        return this.stack.getFirst();
    }

    @Override
    protected String getAdditionalMetaInfoForTableReturnType() {
        List<Pair<String, String>> inputParametersToReturn = this.getMetaInfos().getParametersToReturn();
        if (inputParametersToReturn.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        inputParametersToReturn.sort(Map.Entry.comparingByKey());
        for (Pair<String, String> p : inputParametersToReturn) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("Input ");
            sb.append((String)p.getKey());
            sb.append(" is set to return ");
            sb.append((String)p.getValue());
        }
        return sb.toString();
    }

    @Override
    public void prepare(IGridRegion region) {
        try {
            FunctionalRow funcRow;
            this.top = region.getTop();
            this.left = region.getLeft();
            this.preparedMetaInfos = new CellMetaInfo[region.getBottom() - this.top + 1][region.getRight() - this.left + 1];
            DecisionTable decisionTable = this.getDecisionTable();
            this.saveSimpleRulesMetaInfo(region);
            this.saveCompoundReturnColumn(region);
            IBaseCondition[] conditionRows = decisionTable.getConditionRows();
            IBaseAction[] actionRows = decisionTable.getActionRows();
            if (!DecisionTableHelper.isSmart(decisionTable.getSyntaxNode()) && !DecisionTableHelper.isSimple(decisionTable.getSyntaxNode())) {
                if (conditionRows != null) {
                    for (IBaseDecisionRow iBaseDecisionRow : conditionRows) {
                        this.saveExpressionMetaInfo((FunctionalRow)iBaseDecisionRow, region);
                    }
                }
                if (actionRows != null) {
                    for (IBaseDecisionRow iBaseDecisionRow : actionRows) {
                        this.saveExpressionMetaInfo((FunctionalRow)iBaseDecisionRow, region);
                    }
                }
            }
            if (conditionRows != null) {
                for (IBaseDecisionRow iBaseDecisionRow : conditionRows) {
                    funcRow = (FunctionalRow)iBaseDecisionRow;
                    this.saveValueMetaInfo(funcRow, region);
                }
            }
            if (actionRows != null) {
                for (IBaseDecisionRow iBaseDecisionRow : actionRows) {
                    funcRow = (FunctionalRow)iBaseDecisionRow;
                    this.saveValueMetaInfo(funcRow, region);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void release() {
        this.preparedMetaInfos = null;
    }

    @Override
    public CellMetaInfo getBodyMetaInfo(int row, int col) {
        return this.getPreparedMetaInfo(row, col);
    }

    private void setMetaInfo(CellKey key, List<HeaderMetaInfo> headerMetaInfos, IGridRegion region, Function<HeaderMetaInfo, String> headerToString) {
        if (headerMetaInfos.size() > 2) {
            return;
        }
        int row = key.getRow();
        int col = key.getColumn();
        if (!IGridRegion.Tool.contains(region, col, row)) {
            return;
        }
        IGrid grid = this.getGridTable().getGrid();
        String cellValue = grid.getCell(col, row).getStringValue();
        if (StringUtils.isBlank((CharSequence)cellValue)) {
            return;
        }
        int start = 0;
        int end = headerMetaInfos.size() > 1 ? cellValue.indexOf("/") : cellValue.length();
        ArrayList<SimpleNodeUsage> simpleNodeUsages = new ArrayList<SimpleNodeUsage>();
        for (HeaderMetaInfo headerMetaInfo : headerMetaInfos) {
            String text = headerToString.apply(headerMetaInfo);
            SimpleNodeUsage simpleNodeUsage = new SimpleNodeUsage(start, end, text, headerMetaInfo.getUrl(), headerMetaInfo.getUrl() != null ? NodeType.OTHERUNDERLINED : NodeType.OTHER);
            simpleNodeUsages.add(simpleNodeUsage);
            start = end + 2;
            end = cellValue.length();
        }
        this.setPreparedMetaInfo(row, col, new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, simpleNodeUsages));
    }

    private String buildConditionHint(HeaderMetaInfo headerMetaInfo) {
        String[] parameterNames = headerMetaInfo.getParameterNames();
        String header = headerMetaInfo.getHeader();
        String statement = headerMetaInfo.getConditionStatement();
        IOpenClass[] columnTypes = headerMetaInfo.getColumnTypes();
        StringBuilder sb = new StringBuilder();
        sb.append("Condition: ").append(header);
        if (!StringUtils.isEmpty((CharSequence)statement)) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("Expression: ").append(statement.replaceAll("\n", " "));
        }
        if (!StringUtils.isEmpty((CharSequence)headerMetaInfo.getAdditionalDetails())) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(headerMetaInfo.getAdditionalDetails());
        }
        DecisionTableMetaInfoReader.appendParameters(sb, parameterNames, columnTypes);
        return sb.toString();
    }

    public static void appendParameters(StringBuilder sb, String[] parameterNames, IOpenClass[] columnTypes) {
        if (columnTypes == null || columnTypes.length == 0) {
            return;
        }
        int i = 0;
        if (sb.length() > 0) {
            sb.append("\n");
        }
        if (columnTypes.length > 1) {
            if (parameterNames != null && parameterNames.length > 0 && Arrays.stream(parameterNames).allMatch(Objects::nonNull)) {
                sb.append("Parameters: ");
            } else {
                sb.append("Types: ");
            }
        } else if (parameterNames != null && parameterNames.length > 0) {
            sb.append("Parameter: ");
        } else {
            sb.append("Type: ");
        }
        for (IOpenClass type : columnTypes) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(type.getDisplayName(0));
            if (parameterNames != null && i < parameterNames.length && parameterNames[i] != null) {
                sb.append(" ").append(parameterNames[i]);
            }
            ++i;
        }
    }

    private String buildActionHint(HeaderMetaInfo headerMetaInfo) {
        String[] parameterNames = headerMetaInfo.getParameterNames();
        String header = headerMetaInfo.getHeader();
        String statement = headerMetaInfo.getConditionStatement();
        IOpenClass[] columnTypes = headerMetaInfo.getColumnTypes();
        StringBuilder sb = new StringBuilder();
        sb.append("Action: ").append(header);
        if (!StringUtils.isEmpty((CharSequence)statement)) {
            sb.append("\n").append("Expression: ").append(statement.replaceAll("\n", " "));
        }
        if (!StringUtils.isEmpty((CharSequence)headerMetaInfo.getAdditionalDetails())) {
            sb.append("\n").append(headerMetaInfo.getAdditionalDetails());
        }
        DecisionTableMetaInfoReader.appendParameters(sb, parameterNames, columnTypes);
        return sb.toString();
    }

    private void saveSimpleRulesMetaInfo(IGridRegion region) {
        Map<CellKey, List<HeaderMetaInfo>> simpleRulesConditionMap = this.getMetaInfos().getConditions();
        for (Map.Entry<CellKey, List<HeaderMetaInfo>> entry : simpleRulesConditionMap.entrySet()) {
            this.setMetaInfo(entry.getKey(), entry.getValue(), region, this::buildConditionHint);
        }
        Map<CellKey, HeaderMetaInfo> simpleRulesActionMap = this.getMetaInfos().getActions();
        for (Map.Entry<CellKey, HeaderMetaInfo> entry : simpleRulesActionMap.entrySet()) {
            this.setMetaInfo(entry.getKey(), Collections.singletonList(entry.getValue()), region, this::buildActionHint);
        }
        List<CellKey> list = this.getMetaInfos().getUnmatched();
        for (CellKey cellKey : list) {
            this.setMetaInfo(cellKey, "Unmatched column");
        }
        List<CellKey> list2 = this.getMetaInfos().getRules();
        for (CellKey cellKey : list2) {
            this.setMetaInfo(cellKey, "Rule column");
        }
    }

    private void setMetaInfo(CellKey cellKey, String description) {
        IGrid grid = this.getGridTable().getGrid();
        String cellValue = grid.getCell(cellKey.getColumn(), cellKey.getRow()).getStringValue();
        if (StringUtils.isNotEmpty((CharSequence)cellValue)) {
            SimpleNodeUsage nodeUsage = new SimpleNodeUsage(0, cellValue.length(), description, null, NodeType.OTHER);
            this.setPreparedMetaInfo(cellKey.getRow(), cellKey.getColumn(), new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(nodeUsage)));
        }
    }

    private void saveCompoundReturnColumn(IGridRegion region) {
        Map<CellKey, ReturnMetaInfo> simpleRulesReturnDescriptions = this.getMetaInfos().getReturns();
        for (Map.Entry<CellKey, ReturnMetaInfo> entry : simpleRulesReturnDescriptions.entrySet()) {
            ICell cell;
            String stringValue;
            CellKey key = entry.getKey();
            int row = key.getRow();
            int col = key.getColumn();
            if (!IGridRegion.Tool.contains(region, col, row) || StringUtils.isBlank((CharSequence)(stringValue = (cell = this.getGridTable().getGrid().getCell(col, row)).getStringValue()))) continue;
            ReturnMetaInfo returnMetaInfo = entry.getValue();
            SimpleNodeUsage simpleNodeUsage = new SimpleNodeUsage(0, stringValue.length(), returnMetaInfo.getDetails(), returnMetaInfo.getUri(), returnMetaInfo.getUri() != null ? NodeType.OTHERUNDERLINED : NodeType.OTHER);
            CellMetaInfo metaInfo = new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(simpleNodeUsage));
            this.setPreparedMetaInfo(row, col, metaInfo);
        }
    }

    public void addCondition(int row, int col, String header, String[] parameterNames, String statement, IOpenClass[] columnTypes, String url, String additionalDetails, boolean vertical) {
        List headerMetaInfos = this.getMetaInfos().getConditions().computeIfAbsent(CellKey.CellKeyFactory.getCellKey(col, row), e -> new ArrayList());
        headerMetaInfos.add(new HeaderMetaInfo(header, parameterNames, statement, columnTypes, url, additionalDetails, vertical));
    }

    public void addUnmatched(int row, int col) {
        this.getMetaInfos().getUnmatched().add(CellKey.CellKeyFactory.getCellKey(col, row));
    }

    public void addRule(int row, int col) {
        this.getMetaInfos().getRules().add(CellKey.CellKeyFactory.getCellKey(col, row));
    }

    public void addAction(int row, int col, String header, String[] parameterNames, String statement, IOpenClass[] columnTypes, String url, String additionalInfo) {
        this.getMetaInfos().getActions().put(CellKey.CellKeyFactory.getCellKey(col, row), new HeaderMetaInfo(header, parameterNames, statement, columnTypes, url, additionalInfo, false));
    }

    public void addReturn(int row, int col, String details, String uri) {
        this.getMetaInfos().getReturns().put(CellKey.CellKeyFactory.getCellKey(col, row), new ReturnMetaInfo(details, uri));
    }

    public void addParameterToReturn(String parameterStatement, String returnStatement) {
        this.getMetaInfos().getParametersToReturn().add((Pair<String, String>)Pair.of((Object)parameterStatement, (Object)returnStatement));
    }

    private void saveValueMetaInfo(FunctionalRow funcRow, IGridRegion region) {
        for (int c = 0; c < funcRow.nValues(); ++c) {
            IParameterDeclaration[] params = funcRow.getParams();
            int paramsCount = params == null ? 0 : params.length;
            ILogicalTable valueCell = funcRow.getValueCell(c);
            ILogicalTable paramTable = funcRow.getParamsTable();
            int offsetByParamTable = 0;
            int offsetByValueCell = 0;
            int j = 0;
            for (int i = 0; i < paramsCount; ++i) {
                offsetByParamTable += paramTable.isNormalOrientation() ? ((ILogicalTable)paramTable.getRow(i)).getSource().getWidth() : ((ILogicalTable)paramTable.getRow(i)).getSource().getHeight();
                Object storageValue = funcRow.getStorageValue(i, c);
                int d = 0;
                while (offsetByValueCell < offsetByParamTable) {
                    offsetByValueCell += valueCell.isNormalOrientation() ? ((ILogicalTable)valueCell.getRow(j)).getSource().getWidth() : ((ILogicalTable)valueCell.getRow(j)).getSource().getHeight();
                    ++d;
                    ++j;
                }
                ILogicalTable logicalTable = valueCell.isNormalOrientation() ? (ILogicalTable)valueCell.getSubtable(j - d, 0, j - d, valueCell.getHeight()) : (ILogicalTable)valueCell.getSubtable(0, j - d, valueCell.getWidth(), d);
                if (storageValue instanceof CompositeMethod) {
                    this.addMetaInfoForCompositeMethod(region, logicalTable, 0, 0, storageValue);
                    continue;
                }
                if (storageValue instanceof ArrayHolder) {
                    this.addMetaInfoForArrayHolder(region, logicalTable, storageValue);
                    continue;
                }
                IParameterDeclaration param = params[i];
                if (param == null) continue;
                IOpenClass type = param.getType();
                boolean multiValue = false;
                if (type.isArray()) {
                    multiValue = true;
                    type = type.getAggregateInfo().getComponentType(type);
                }
                ICell cell = logicalTable.getCell(0, 0);
                this.setPreparedMetaInfo(cell.getAbsoluteRow(), cell.getAbsoluteColumn(), type, multiValue);
            }
        }
    }

    private void addMetaInfoForCompositeMethod(IGridRegion region, ILogicalTable valueCell, int i, int j, Object storageValue) {
        ICell cell = valueCell.getCell(j, i);
        int row = cell.getAbsoluteRow();
        int col = cell.getAbsoluteColumn();
        if (IGridRegion.Tool.contains(region, col, row)) {
            String stringValue = cell.getStringValue();
            int startIndex = stringValue.indexOf(61) + 1;
            List<NodeUsage> nodeUsages = MetaInfoReaderUtils.getNodeUsages((CompositeMethod)storageValue, stringValue.substring(startIndex), startIndex);
            this.setPreparedMetaInfo(row, col, new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, nodeUsages));
        }
    }

    private void addMetaInfoForArrayHolder(IGridRegion region, ILogicalTable valueCell, Object storageValue) {
        ArrayHolder arrayHolder = (ArrayHolder)storageValue;
        if (arrayHolder.is2DimArray()) {
            Object[][] values = arrayHolder.get2DimValues();
            for (int i = 0; i < values.length; ++i) {
                for (int j = 0; j < values[i].length; ++j) {
                    if (!(values[i][j] instanceof CompositeMethod)) continue;
                    this.addMetaInfoForCompositeMethod(region, valueCell, j, i, values[i][j]);
                }
            }
        } else {
            Object[] values = arrayHolder.getValues();
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] instanceof CompositeMethod)) continue;
                if (valueCell.getHeight() > 1) {
                    this.addMetaInfoForCompositeMethod(region, valueCell, i, 0, values[i]);
                    continue;
                }
                this.addMetaInfoForCompositeMethod(region, valueCell, 0, i, values[i]);
            }
        }
    }

    private void saveExpressionMetaInfo(FunctionalRow funcRow, IGridRegion region) {
        ICell codeCell = funcRow.getCodeTable().getCell(0, 0);
        int row = codeCell.getAbsoluteRow();
        int col = codeCell.getAbsoluteColumn();
        if (IGridRegion.Tool.contains(region, col, row)) {
            List<CellMetaInfo> metaInfoList = MetaInfoReaderUtils.getMetaInfo(funcRow.getSourceCodeModule(), funcRow.getMethod());
            this.setPreparedMetaInfo(row, col, metaInfoList.get(0));
        }
        ILogicalTable paramsTable = funcRow.getParamsTable();
        IParameterDeclaration[] params = funcRow.getParams();
        if (params != null && params.length > 0 && params[0] != null) {
            IParameterDeclaration param = params[0];
            ICell paramCell = paramsTable.getCell(0, 0);
            row = paramCell.getAbsoluteRow();
            col = paramCell.getAbsoluteColumn();
            if (IGridRegion.Tool.contains(region, col, row)) {
                this.setPreparedMetaInfo(row, col, this.getMetaInfo(paramsTable, param.getType()));
            }
        }
    }

    protected CellMetaInfo getMetaInfo(ILogicalTable paramsTable, IOpenClass type) {
        IOpenClass typeForLink = type;
        while (typeForLink.getMetaInfo() == null && typeForLink.isArray()) {
            typeForLink = typeForLink.getComponentClass();
        }
        ILogicalTable table = (ILogicalTable)paramsTable.getRow(0);
        if (table != null) {
            IMetaInfo metaInfo;
            IdentifierNode[] paramNodes;
            GridCellSourceCodeModule source = new GridCellSourceCodeModule(table.getSource());
            try {
                paramNodes = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)"[] \n\r");
            }
            catch (OpenLCompilationException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                return null;
            }
            if (paramNodes.length > 0 && (metaInfo = typeForLink.getMetaInfo()) != null) {
                SimpleNodeUsage nodeUsage = new SimpleNodeUsage(paramNodes[0], metaInfo.getDisplayName(0), metaInfo.getSourceUrl(), NodeType.DATATYPE);
                return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(nodeUsage));
            }
        }
        return null;
    }

    private DecisionTable getDecisionTable() {
        if (this.decisionTable != null) {
            return this.decisionTable;
        }
        return ((DecisionTableBoundNode)((Object)this.getBoundNode())).getDecisionTable();
    }

    private CellMetaInfo getPreparedMetaInfo(int row, int col) {
        if (this.preparedMetaInfos == null) {
            this.prepare(this.getGridTable().getRegion());
        }
        int r = row - this.top;
        int c = col - this.left;
        if (r >= 0 && r < this.preparedMetaInfos.length && c >= 0 && c < this.preparedMetaInfos[r].length) {
            return this.preparedMetaInfos[r][c];
        }
        return null;
    }

    private void setPreparedMetaInfo(int row, int col, CellMetaInfo metaInfo) {
        int r = row - this.top;
        int c = col - this.left;
        if (r >= 0 && r < this.preparedMetaInfos.length && c >= 0 && c < this.preparedMetaInfos[r].length) {
            this.preparedMetaInfos[r][c] = metaInfo;
        }
    }

    private void setPreparedMetaInfo(int row, int col, IOpenClass type, boolean multiValue) {
        CellMetaInfo metaInfo = new CellMetaInfo(type, multiValue);
        CellMetaInfo previous = this.getPreparedMetaInfo(row, col);
        if (previous != null && previous.getUsedNodes() != null) {
            metaInfo.setUsedNodes(previous.getUsedNodes());
        }
        this.setPreparedMetaInfo(row, col, metaInfo);
    }

    private static class HeaderMetaInfo {
        String header;
        String[] parameterNames;
        String statement;
        IOpenClass[] columnTypes;
        String additionalDetails;
        String url;
        boolean vertical;

        public HeaderMetaInfo(String headerName, String[] parameterNames, String conditionStatement, IOpenClass[] columnTypes, String url, String additionalDetails, boolean vertical) {
            if (parameterNames != null && columnTypes != null && parameterNames.length != columnTypes.length) {
                throw new IllegalArgumentException();
            }
            this.header = headerName;
            this.parameterNames = parameterNames;
            this.statement = conditionStatement;
            this.columnTypes = columnTypes;
            this.additionalDetails = additionalDetails;
            this.url = url;
            this.vertical = vertical;
        }

        public boolean isVertical() {
            return this.vertical;
        }

        public String getUrl() {
            return this.url;
        }

        public String getAdditionalDetails() {
            return this.additionalDetails;
        }

        public String getHeader() {
            return this.header;
        }

        public String[] getParameterNames() {
            return this.parameterNames;
        }

        public String getConditionStatement() {
            return this.statement;
        }

        public IOpenClass[] getColumnTypes() {
            return this.columnTypes;
        }
    }

    private static class ReturnMetaInfo {
        final String details;
        final String uri;

        public ReturnMetaInfo(String details, String uri) {
            this.details = details;
            this.uri = uri;
        }

        public String getDetails() {
            return this.details;
        }

        public String getUri() {
            return this.uri;
        }
    }

    public static class MetaInfoHolder {
        private final Map<CellKey, List<HeaderMetaInfo>> conditions = new HashMap<CellKey, List<HeaderMetaInfo>>();
        private final Map<CellKey, HeaderMetaInfo> actions = new HashMap<CellKey, HeaderMetaInfo>();
        private final Map<CellKey, ReturnMetaInfo> returns = new HashMap<CellKey, ReturnMetaInfo>();
        private final List<Pair<String, String>> parametersToReturn = new ArrayList<Pair<String, String>>();
        private final List<CellKey> unmatched = new ArrayList<CellKey>();
        private final List<CellKey> rules = new ArrayList<CellKey>();

        public Map<CellKey, List<HeaderMetaInfo>> getConditions() {
            return this.conditions;
        }

        public Map<CellKey, HeaderMetaInfo> getActions() {
            return this.actions;
        }

        public Map<CellKey, ReturnMetaInfo> getReturns() {
            return this.returns;
        }

        public List<Pair<String, String>> getParametersToReturn() {
            return this.parametersToReturn;
        }

        public List<CellKey> getUnmatched() {
            return this.unmatched;
        }

        public List<CellKey> getRules() {
            return this.rules;
        }

        public void merge(MetaInfoHolder metaInfoHolder) {
            if (metaInfoHolder == null) {
                return;
            }
            this.conditions.putAll(metaInfoHolder.conditions);
            this.actions.putAll(metaInfoHolder.actions);
            this.returns.putAll(metaInfoHolder.returns);
            this.parametersToReturn.addAll(metaInfoHolder.parametersToReturn);
            this.unmatched.addAll(metaInfoHolder.unmatched);
            this.rules.addAll(metaInfoHolder.rules);
        }
    }
}

